/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.ByteStoreColumnReader;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.ColumnReader;
import uk.ac.starlink.table.storage.ColumnStore;
import uk.ac.starlink.table.storage.FileByteStore;
import uk.ac.starlink.table.storage.NioByteStoreAccess;
import uk.ac.starlink.util.DataBufferedOutputStream;

class IndexedMappedColumnStore
implements ColumnStore {
    private final Codec codec_;
    private final File auxFile_;
    private final DataBufferedOutputStream auxOut_;
    private ByteBuffer indexBuf_;
    private long auxOffset_;
    private long nrow_;
    private ByteBuffer[] auxBufs_;

    public IndexedMappedColumnStore(Codec codec, ByteBuffer bbuf, File auxFile) throws IOException {
        this.codec_ = codec;
        this.indexBuf_ = bbuf;
        this.auxFile_ = auxFile;
        this.auxOut_ = new DataBufferedOutputStream(new FileOutputStream(auxFile));
    }

    @Override
    public void acceptCell(Object value) throws IOException {
        this.indexBuf_.putLong(this.auxOffset_);
        this.auxOffset_ += (long)this.codec_.encode(value, this.auxOut_);
        ++this.nrow_;
    }

    @Override
    public void endCells() throws IOException {
        this.auxOut_.close();
        this.indexBuf_ = this.indexBuf_.asReadOnlyBuffer();
        this.auxBufs_ = FileByteStore.toByteBuffers(this.auxFile_);
    }

    @Override
    public ColumnReader createReader() {
        final ByteBuffer ixBuf = this.indexBuf_.duplicate();
        ByteStoreAccess auxAccess = NioByteStoreAccess.createAccess(NioByteStoreAccess.copyBuffers(this.auxBufs_));
        return new ByteStoreColumnReader(this.codec_, auxAccess, this.nrow_){

            @Override
            public long getAccessOffset(long ix) {
                return ixBuf.getLong(Tables.checkedLongToInt(8L * ix));
            }
        };
    }
}

