/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.table.storage;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.table.storage.NioByteStoreAccess;

class MultiNioAccess
extends NioByteStoreAccess {
    private final ByteBuffer[] bbufs_;
    private final int[] bufLengs_;
    private final int isoLeng_;
    private final long totLeng_;
    private int ibuf_;

    public MultiNioAccess(ByteBuffer[] bbufs) {
        this.bbufs_ = bbufs;
        this.bufLengs_ = new int[bbufs.length];
        long tlen = 0L;
        boolean isIso = true;
        for (int ib = 0; ib < bbufs.length; ++ib) {
            int len;
            this.bufLengs_[ib] = len = bbufs[ib].limit();
            tlen += (long)len;
            isIso = isIso && (ib == bbufs.length - 1 || len == this.bufLengs_[0]);
        }
        this.totLeng_ = tlen;
        this.isoLeng_ = isIso ? this.bufLengs_[0] : -1;
    }

    @Override
    protected ByteBuffer getBuffer(int nbyte) throws IOException {
        int n;
        ByteBuffer buf = this.bbufs_[this.ibuf_];
        int nleft = buf.remaining();
        if (nleft >= nbyte) {
            return buf;
        }
        if (nleft == 0 && this.ibuf_ + 1 < this.bbufs_.length && nbyte <= this.bbufs_[this.ibuf_ + 1].limit()) {
            this.bbufs_[++this.ibuf_].position(0);
            return this.bbufs_[this.ibuf_];
        }
        byte[] tmp = new byte[nbyte];
        for (int pos = 0; pos < nbyte; pos += n) {
            if (!this.bbufs_[this.ibuf_].hasRemaining()) {
                if (this.ibuf_ + 1 >= this.bbufs_.length) {
                    throw new EOFException();
                }
                this.bbufs_[++this.ibuf_].position(0);
            }
            n = Math.min(nbyte - pos, this.bbufs_[this.ibuf_].remaining());
            this.bbufs_[this.ibuf_].get(tmp, pos, n);
        }
        return ByteBuffer.wrap(tmp);
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos >= 0L && pos < this.totLeng_) {
            if (this.isoLeng_ > 0) {
                this.ibuf_ = (int)(pos / (long)this.isoLeng_);
                this.bbufs_[this.ibuf_].position((int)(pos % (long)this.isoLeng_));
            } else {
                long ip0 = 0L;
                for (int ib = 0; ib < this.bbufs_.length; ++ib) {
                    long ip1 = ip0 + (long)this.bufLengs_[ib];
                    if (pos >= ip0 && pos < ip1) {
                        this.ibuf_ = ib;
                        this.bbufs_[this.ibuf_].position((int)(pos - ip0));
                        return;
                    }
                    ip0 = ip1;
                }
            }
        } else {
            throw new IOException("Out of range");
        }
    }

    @Override
    public void skip(int nskip) throws IOException {
        int n;
        for (int isk = 0; isk < nskip; isk += n) {
            if (!this.bbufs_[this.ibuf_].hasRemaining()) {
                this.bbufs_[++this.ibuf_].position(0);
            }
            n = Math.min(nskip - isk, this.bbufs_[this.ibuf_].remaining());
            this.bbufs_[this.ibuf_].position(this.bbufs_[this.ibuf_].position() + n);
        }
    }
}

