/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import org.json.JSONArray;
import org.json.JSONObject;
import uk.ac.starlink.hapi.HapiBins;
import uk.ac.starlink.hapi.HapiType;

public interface HapiParam {
    public String getName();

    public HapiType<?, ?> getType();

    public int getLength();

    public int[] getSize();

    public String[] getUnits();

    public String[] getLabel();

    public String getFill();

    public String getDescription();

    public HapiBins[] getBins();

    public static HapiParam fromJson(JSONObject json) {
        HapiBins[] binsArray;
        int[] sizes;
        final String name = json.optString("name", null);
        final HapiType<?, ?> type = HapiType.fromText(json.optString("type"));
        final int length = json.optInt("length", -1);
        JSONArray sizeArray = json.optJSONArray("size");
        if (sizeArray != null) {
            int nd = sizeArray.length();
            sizes = new int[nd];
            for (int i = 0; i < nd; ++i) {
                sizes[i] = sizeArray.getInt(i);
            }
        } else {
            sizes = null;
        }
        final String[] units = HapiParam.stringOrArray(json.opt("units"));
        final String[] label = HapiParam.stringOrArray(json.opt("labels"));
        final String fill = json.optString("fill", null);
        final String description = json.optString("description", null);
        JSONArray binsArrayJson = json.optJSONArray("bins");
        if (binsArrayJson != null) {
            int binsDim = binsArrayJson.length();
            binsArray = new HapiBins[binsDim];
            for (int idim = 0; idim < binsDim; ++idim) {
                JSONObject binsObj = binsArrayJson.optJSONObject(idim);
                binsArray[idim] = binsObj == null ? null : HapiBins.fromJson(binsObj);
            }
        } else {
            binsArray = null;
        }
        return new HapiParam(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public HapiType<?, ?> getType() {
                return type;
            }

            @Override
            public int getLength() {
                return length;
            }

            @Override
            public int[] getSize() {
                return sizes;
            }

            @Override
            public String[] getUnits() {
                return units;
            }

            @Override
            public String[] getLabel() {
                return label;
            }

            @Override
            public String getFill() {
                return fill;
            }

            @Override
            public String getDescription() {
                return description;
            }

            @Override
            public HapiBins[] getBins() {
                return binsArray;
            }
        };
    }

    public static String[] stringOrArray(Object json) {
        if (json instanceof String) {
            return new String[]{(String)json};
        }
        if (json instanceof JSONArray) {
            JSONArray jarray = (JSONArray)json;
            int nel = jarray.length();
            String[] items = new String[nel];
            for (int i = 0; i < nel; ++i) {
                items[i] = jarray.optString(i, null);
            }
            return items;
        }
        return null;
    }
}

