/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hapi;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import uk.ac.starlink.hapi.CsvReader;
import uk.ac.starlink.hapi.HapiInfo;
import uk.ac.starlink.hapi.HapiParam;
import uk.ac.starlink.hapi.ParamReader;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.EmptyRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.util.IOSupplier;
import uk.ac.starlink.util.IOUtils;

public class HapiTableReader {
    private final ParamReader[] paramRdrs_;
    private final ColumnInfo[] colInfos_;
    private final int nparam_;
    private final int ncol_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.hapi");

    public HapiTableReader(HapiParam[] params) {
        this.nparam_ = params.length;
        this.paramRdrs_ = new ParamReader[this.nparam_];
        ArrayList<ColumnInfo> cinfoList = new ArrayList<ColumnInfo>();
        for (int ip = 0; ip < this.nparam_; ++ip) {
            ParamReader paramRdr;
            this.paramRdrs_[ip] = paramRdr = ParamReader.createReader(params[ip]);
            int nc = paramRdr.getColumnCount();
            for (int ic = 0; ic < nc; ++ic) {
                cinfoList.add(paramRdr.getColumnInfo(ic));
            }
        }
        this.colInfos_ = cinfoList.toArray(new ColumnInfo[0]);
        this.ncol_ = this.colInfos_.length;
    }

    public StarTable createStarTable(final IOSupplier<RowSequence> rseqSupplier) {
        return new AbstractStarTable(){

            @Override
            public int getColumnCount() {
                return HapiTableReader.this.colInfos_.length;
            }

            @Override
            public ColumnInfo getColumnInfo(int ic) {
                return HapiTableReader.this.colInfos_[ic];
            }

            @Override
            public long getRowCount() {
                return -1L;
            }

            @Override
            public RowSequence getRowSequence() throws IOException {
                if (rseqSupplier != null) {
                    return (RowSequence)rseqSupplier.get();
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    public RowSequence createRowSequenceUsingHeader(InputStream in) throws IOException {
        int[] overread1 = new int[1];
        HapiInfo hdr = HapiInfo.fromCommentedStream(in, overread1);
        int b0 = overread1[0];
        Byte byte0 = (b0 & 0xFF) == b0 ? Byte.valueOf((byte)b0) : null;
        String fmt = hdr.getFormat();
        return this.createRowSequence(in, byte0, fmt);
    }

    public RowSequence createRowSequence(InputStream in, Byte byte0, String fmt) throws IOException {
        byte b0;
        if (byte0 == null) {
            int b = in.read();
            if (b >= 0) {
                byte0 = (byte)b;
            } else {
                return EmptyRowSequence.getInstance();
            }
        }
        if ((b0 = byte0.byteValue()) == 123 && ("csv".equals(fmt) || "binary".equals(fmt))) {
            return HapiTableReader.createUnexpectedJsonRowSequence(in, b0);
        }
        if ("csv".equals(fmt)) {
            return this.createCsvRowSequence(in, byte0);
        }
        if ("binary".equals(fmt)) {
            return this.createBinaryRowSequence(in, byte0);
        }
        if ("json".equals(fmt)) {
            throw new TableFormatException("Unsupported HAPI data format " + fmt);
        }
        throw new TableFormatException("Unknown HAPI data format " + fmt);
    }

    private RowSequence createCsvRowSequence(final InputStream in, Byte byte0) {
        final CsvReader csvRdr = new CsvReader();
        if (byte0 != null) {
            csvRdr.setPrefixByte(byte0);
        }
        final Object[][] results = HapiTableReader.createResultsArray(this.paramRdrs_);
        return new RowSequence(){
            Object[] row_;

            @Override
            public boolean next() throws IOException {
                String[] csvRow = csvRdr.readCsvRow(in);
                if (csvRow != null) {
                    int foff = 0;
                    int coff = 0;
                    this.row_ = new Object[HapiTableReader.this.ncol_];
                    for (int ip = 0; ip < HapiTableReader.this.nparam_; ++ip) {
                        ParamReader paramRdr = HapiTableReader.this.paramRdrs_[ip];
                        Object[] result = results[ip];
                        int nf = paramRdr.getFieldCount();
                        int nc = paramRdr.getColumnCount();
                        paramRdr.readStringValues(csvRow, foff, result);
                        System.arraycopy(result, 0, this.row_, coff, nc);
                        foff += nf;
                        coff += nc;
                    }
                    return true;
                }
                this.row_ = null;
                return false;
            }

            @Override
            public Object[] getRow() {
                if (this.row_ != null) {
                    return this.row_;
                }
                throw new IllegalStateException();
            }

            @Override
            public Object getCell(int icol) {
                return this.getRow()[icol];
            }

            @Override
            public void close() throws IOException {
                in.close();
            }
        };
    }

    private RowSequence createBinaryRowSequence(final InputStream in, final Byte byte0) {
        final int bufsize = Arrays.stream(this.paramRdrs_).mapToInt(prdr -> prdr.getByteCount()).sum();
        final Object[][] results = HapiTableReader.createResultsArray(this.paramRdrs_);
        return new RowSequence(){
            Byte byte0_;
            Object[] row_;
            final byte[] buf_;
            {
                this.byte0_ = byte0;
                this.buf_ = new byte[bufsize];
            }

            @Override
            public boolean next() throws IOException {
                if (this.fillBuffer()) {
                    int boff = 0;
                    int coff = 0;
                    this.row_ = new Object[HapiTableReader.this.ncol_];
                    for (int ip = 0; ip < HapiTableReader.this.nparam_; ++ip) {
                        ParamReader prdr = HapiTableReader.this.paramRdrs_[ip];
                        Object[] result = results[ip];
                        int nb = prdr.getByteCount();
                        int nc = prdr.getColumnCount();
                        prdr.readBinaryValues(this.buf_, boff, result);
                        System.arraycopy(result, 0, this.row_, coff, nc);
                        boff += nb;
                        coff += nc;
                    }
                    return true;
                }
                this.row_ = null;
                return false;
            }

            @Override
            public Object[] getRow() {
                if (this.row_ != null) {
                    return this.row_;
                }
                throw new IllegalStateException();
            }

            @Override
            public Object getCell(int icol) {
                return this.row_[icol];
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            private boolean fillBuffer() throws IOException {
                int len = this.buf_.length;
                int off = 0;
                if (this.byte0_ != null) {
                    this.buf_[0] = this.byte0_;
                    ++off;
                    --len;
                    this.byte0_ = null;
                }
                while (len > 0) {
                    int nb = in.read(this.buf_, off, len);
                    if (nb == -1) {
                        if (off == 0) {
                            return false;
                        }
                        String msg = "Unexpected end of HAPI stream";
                        throw new EOFException(msg);
                    }
                    len -= nb;
                    off += nb;
                }
                return true;
            }
        };
    }

    private static RowSequence createUnexpectedJsonRowSequence(InputStream in, byte byte0) throws IOException {
        JSONObject status;
        JSONObject json;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append((char)byte0);
        sbuf.append(new String(IOUtils.readBytes(in, 100000), StandardCharsets.UTF_8));
        try {
            json = new JSONObject(sbuf.toString());
        }
        catch (JSONException e) {
            json = null;
        }
        JSONObject jSONObject = status = json == null ? null : json.optJSONObject("status");
        if (status != null) {
            logger_.info("JSON status instead of data: " + status.toString());
            return EmptyRowSequence.getInstance();
        }
        throw new IOException("Unexpected content starting '" + (char)byte0 + "' in data stream");
    }

    private static Object[][] createResultsArray(ParamReader[] paramRdrs) {
        Object[][] results = new Object[paramRdrs.length][];
        for (int ip = 0; ip < paramRdrs.length; ++ip) {
            results[ip] = new Object[paramRdrs[ip].getColumnCount()];
        }
        return results;
    }
}

