/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import uk.ac.starlink.auth.AuthConnection;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.AuthStatus;
import uk.ac.starlink.auth.AuthType;
import uk.ac.starlink.auth.AuthUtil;
import uk.ac.starlink.auth.BadChallengeException;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.ContextFactory;
import uk.ac.starlink.auth.Redirector;
import uk.ac.starlink.auth.UrlConnector;
import uk.ac.starlink.auth.UserInterface;

public class AuthManager {
    private volatile UserInterface ui_;
    private final List<AuthScheme> schemes_;
    private final ContextList contexts_;
    private final Redirector dfltRedirector_;
    private static AuthManager instance_ = new AuthManager(null, AuthUtil.getDefaultSchemes(), Redirector.DEFAULT);
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.auth");

    public AuthManager(UserInterface ui, AuthScheme[] schemes, Redirector dfltRedirector) {
        this.ui_ = ui;
        this.schemes_ = new CopyOnWriteArrayList<AuthScheme>(Arrays.asList(schemes));
        this.dfltRedirector_ = dfltRedirector;
        this.contexts_ = new ContextList();
    }

    public void setUserInterface(UserInterface ui) {
        this.ui_ = ui;
    }

    public UserInterface getUserInterface() {
        return this.ui_;
    }

    public List<AuthScheme> getSchemes() {
        return this.schemes_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ContextList contextList = this.contexts_;
        synchronized (contextList) {
            this.contexts_.clear();
        }
    }

    public URLConnection connect(URL url) throws IOException {
        return this.connect(url, null);
    }

    public URLConnection connect(URL url, UrlConnector connector) throws IOException {
        return this.connect(url, connector, this.dfltRedirector_);
    }

    public URLConnection connect(URL url, UrlConnector connector, Redirector redirector) throws IOException {
        return this.makeConnection(url, connector, redirector).getConnection();
    }

    public AuthConnection makeConnection(URL url, UrlConnector connector, Redirector redirector) throws IOException {
        HttpURLConnection hconn;
        int code;
        TestedContext tcontext0 = this.getUrlContext(url);
        AuthConnection aconn = this.connectWithContext(url, connector, tcontext0, redirector);
        if (tcontext0 != null) {
            this.assessAuthAttempt(tcontext0, aconn);
        }
        URLConnection conn = aconn.getConnection();
        if (this.ui_ != null && conn instanceof HttpURLConnection && ((code = (hconn = (HttpURLConnection)conn).getResponseCode()) == 401 || code == 403)) {
            Challenge[] challenges = AuthUtil.getChallenges(hconn);
            if (challenges.length == 0 && code == 401) {
                throw new IOException("401 with no WWW-Authenticate challenges: " + url);
            }
            if (challenges.length > 0) {
                AuthConnection aconn2;
                TestedContext chContext = this.getChallengeContext(challenges, url);
                if (chContext != null && this.assessAuthAttempt(chContext, aconn2 = this.connectWithContext(url, connector, chContext, redirector))) {
                    return aconn2;
                }
                ContextFactory cfact = this.getPreferredContextFactory(challenges, url);
                if (cfact == null) {
                    throw new IOException("No supported auth-schemes in WWW-Authenticate");
                }
                return this.connectWithChallenge(url, connector, cfact, redirector);
            }
        }
        return aconn;
    }

    public InputStream openStream(URL url) throws IOException {
        return this.connect(url).getInputStream();
    }

    public URLConnection followRedirects(URLConnection conn, UrlConnector connector, Redirector redirector) throws IOException {
        URL url1 = redirector.getRedirectUrl(conn);
        if (url1 != null) {
            int hcode = conn instanceof HttpURLConnection ? ((HttpURLConnection)conn).getResponseCode() : -1;
            logger_.info("HTTP " + hcode + " redirect to " + url1);
            return this.connect(url1, connector, redirector);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthStatus authcheck(URL authcheckUrl, final boolean isHead, boolean isForceLogin) throws IOException {
        AuthType authType;
        Redirector redir = Redirector.NO_REDIRECT;
        UrlConnector connector = new UrlConnector(){

            @Override
            public void connect(HttpURLConnection conn) throws IOException {
                conn.setInstanceFollowRedirects(false);
                if (isHead) {
                    conn.setRequestMethod("HEAD");
                }
                conn.connect();
            }
        };
        URLConnection conn1 = authcheckUrl.openConnection();
        if (!(conn1 instanceof HttpURLConnection)) {
            return AuthStatus.NO_AUTH;
        }
        HttpURLConnection hconn1 = (HttpURLConnection)conn1;
        connector.connect(hconn1);
        int code1 = hconn1.getResponseCode();
        Challenge[] challenges = AuthUtil.getChallenges(hconn1);
        if (code1 == 401 || code1 == 403) {
            authType = AuthType.REQUIRED;
        } else if (code1 >= 200 && code1 < 300) {
            authType = challenges.length > 0 ? AuthType.OPTIONAL : AuthType.NONE;
        } else {
            return new AuthStatus(AuthType.UNKNOWN);
        }
        logger_.info("Initial Authcheck connection to " + authcheckUrl + ": " + code1);
        if (challenges.length > 0 && (authType == AuthType.REQUIRED || isForceLogin)) {
            if (isForceLogin) {
                ContextList contextList = this.contexts_;
                synchronized (contextList) {
                    for (Challenge ch : challenges) {
                        this.contexts_.removeIf(item -> item.context_.isChallengeDomain(ch, authcheckUrl));
                    }
                }
            }
            AuthConnection aconn = null;
            TestedContext chContext = this.getChallengeContext(challenges, authcheckUrl);
            if (chContext != null) {
                assert (!isForceLogin);
                AuthConnection aconn1 = this.connectWithContext(authcheckUrl, connector, chContext, redir);
                if (this.assessAuthAttempt(chContext, aconn1)) {
                    aconn = aconn1;
                }
            }
            if (aconn == null) {
                ContextFactory cfact = this.getPreferredContextFactory(challenges, authcheckUrl);
                if (cfact == null) {
                    logger_.warning("No supported auth-schemes in WWW-Authenticate");
                } else if (this.ui_ != null) {
                    aconn = this.connectWithChallenge(authcheckUrl, connector, cfact, redir);
                }
            }
            if (aconn != null && aconn.getConnection() instanceof HttpURLConnection) {
                HttpURLConnection hconn2 = (HttpURLConnection)aconn.getConnection();
                int code2 = hconn2.getResponseCode();
                AuthContext context2 = aconn.getContext();
                boolean isAuthenticated = code2 == 200 && context2 != null && context2.hasCredentials();
                String authId = AuthUtil.getAuthenticatedId(aconn);
                return new AuthStatus(authType, isAuthenticated, authId);
            }
        }
        return new AuthStatus(authType);
    }

    private boolean assessAuthAttempt(TestedContext tcontext, AuthConnection aconn) {
        boolean isSuccess;
        int code;
        URLConnection conn = aconn.getConnection();
        if (conn instanceof HttpURLConnection) {
            try {
                code = ((HttpURLConnection)conn).getResponseCode();
            }
            catch (IOException e) {
                code = -1;
            }
        } else {
            code = -1;
        }
        boolean isAnonymous = !tcontext.context_.hasCredentials();
        boolean isAuthFailure = code == 401 || code == 403;
        boolean bl = isSuccess = code >= 200 && code < 400;
        if (isSuccess) {
            tcontext.hasSucceeded_ = true;
            return true;
        }
        if (isAuthFailure) {
            tcontext.hasFailed_ = true;
            return isAnonymous;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestedContext getUrlContext(URL url) {
        ContextList contextList = this.contexts_;
        synchronized (contextList) {
            return this.contexts_.stream().filter(tc -> tc.context_.isUrlDomain(url)).findFirst().orElse(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestedContext getChallengeContext(Challenge[] challenges, URL url) {
        ContextList contextList = this.contexts_;
        synchronized (contextList) {
            return this.contexts_.stream().filter(tcontext -> Arrays.stream(challenges).anyMatch(ch -> tcontext.context_.isChallengeDomain((Challenge)ch, url))).findFirst().orElse(null);
        }
    }

    private ContextFactory getPreferredContextFactory(Challenge[] challenges, URL url) {
        for (AuthScheme scheme : this.schemes_) {
            for (Challenge ch : challenges) {
                ContextFactory cfact;
                try {
                    cfact = scheme.createContextFactory(ch, url);
                }
                catch (BadChallengeException e) {
                    logger_.warning("Challenge error reported by scheme " + scheme.getName() + ": " + e.getMessage() + " (" + ch + ")");
                    cfact = null;
                }
                if (cfact == null) continue;
                return cfact;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthConnection connectWithChallenge(URL url, UrlConnector connector, ContextFactory cfact, Redirector redirector) throws IOException {
        AuthConnection aconn;
        block12: {
            int code;
            AuthContext context;
            block13: {
                while (true) {
                    logger_.info("Acquire credentials for " + url);
                    context = cfact.createContext(this.ui_);
                    if (context == null) {
                        TestedContext anonContext = new TestedContext(cfact.createUnauthContext());
                        assert (!anonContext.context_.hasCredentials());
                        logger_.info("Configuring anonymous context for " + url);
                        ContextList contextList = this.contexts_;
                        synchronized (contextList) {
                            this.contexts_.add(anonContext);
                        }
                        return this.connectWithContext(url, connector, anonContext, redirector);
                    }
                    assert (context.hasCredentials());
                    TestedContext tcontext = new TestedContext(context);
                    aconn = this.connectWithContext(url, connector, tcontext, redirector);
                    URLConnection conn = aconn.getConnection();
                    if (!(conn instanceof HttpURLConnection)) break block12;
                    HttpURLConnection hconn = (HttpURLConnection)conn;
                    code = hconn.getResponseCode();
                    ContextList contextList = this.contexts_;
                    synchronized (contextList) {
                        this.contexts_.add(tcontext);
                    }
                    if (code != 401 && code != 403) break block13;
                    tcontext.hasFailed_ = true;
                    if (!this.ui_.canRetry()) break;
                    this.ui_.message(new String[]{"Authentication failed", AuthUtil.authFailureMessage(hconn)});
                }
                logger_.info("Unsuccessful authentication (" + code + ") for " + url);
                return aconn;
            }
            if (code >= 200 && code < 300) {
                tcontext.hasSucceeded_ = true;
                AuthScheme scheme = context.getScheme();
                StringBuffer sbuf = new StringBuffer().append("Configuring authenticated context ");
                if (context.hasCredentials()) {
                    sbuf.append("using scheme ").append(context.getScheme().getName());
                }
                sbuf.append(" for ").append(url).append(" (").append(code).append(")");
                logger_.info(sbuf.toString());
            }
            return aconn;
        }
        return aconn;
    }

    private AuthConnection connectWithContext(URL url, UrlConnector connector, TestedContext tcontext, Redirector redirector) throws IOException {
        AuthContext context = tcontext == null ? null : tcontext.context_;
        logger_.config((context == null ? "Unauthenticated" : (context.hasCredentials() ? "Authenticated" : "Anonymous")) + " connection to " + url);
        AuthConnection aconn = AuthManager.simpleConnect(url, connector, tcontext);
        URLConnection conn = aconn.getConnection();
        URL url1 = redirector.getRedirectUrl(conn);
        if (url1 == null) {
            return aconn;
        }
        int hcode = conn instanceof HttpURLConnection ? ((HttpURLConnection)conn).getResponseCode() : -1;
        logger_.config("HTTP " + hcode + " redirect to " + url1);
        return this.makeConnection(url1, connector, redirector);
    }

    private static AuthConnection simpleConnect(URL url, UrlConnector connector, TestedContext tcontext) throws IOException {
        HttpURLConnection hconn;
        AuthContext context = tcontext == null ? null : tcontext.context_;
        URLConnection conn = url.openConnection();
        HttpURLConnection httpURLConnection = hconn = conn instanceof HttpURLConnection ? (HttpURLConnection)conn : null;
        if (hconn != null) {
            hconn.setInstanceFollowRedirects(false);
        }
        if (hconn != null && context != null) {
            context.configureConnection(hconn);
        }
        if (hconn != null && connector != null) {
            connector.connect(hconn);
        } else {
            conn.connect();
        }
        return new AuthConnection(conn, context);
    }

    public static AuthManager getInstance() {
        return instance_;
    }

    public static void setDefaultInstance(AuthManager authManager) {
        instance_ = authManager;
    }

    private static class ContextList
    extends AbstractSequentialList<TestedContext> {
        private final List<TestedContext> list_ = new ArrayList<TestedContext>();
        private static final Comparator<TestedContext> CONTEXT_COMPARATOR = (c1, c2) -> {
            if (c1.hasFailed_ != c2.hasFailed_) {
                return c1.hasFailed_ ? 1 : -1;
            }
            if (c1.hasSucceeded_ != c2.hasSucceeded_) {
                return c1.hasSucceeded_ ? -1 : 1;
            }
            return Integer.compare(System.identityHashCode(c1.context_), System.identityHashCode(c2.context_));
        };

        ContextList() {
        }

        @Override
        public int size() {
            return this.list_.size();
        }

        @Override
        public ListIterator<TestedContext> listIterator(int index) {
            this.list_.removeIf(item -> item.context_.isExpired());
            this.list_.sort(CONTEXT_COMPARATOR);
            return this.list_.listIterator(index);
        }

        @Override
        public void clear() {
            this.list_.clear();
        }
    }

    private static class TestedContext {
        final AuthContext context_;
        boolean hasSucceeded_;
        boolean hasFailed_;

        TestedContext(AuthContext context) {
            this.context_ = context;
        }
    }
}

