/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import uk.ac.starlink.auth.AuthContext;
import uk.ac.starlink.auth.AuthScheme;
import uk.ac.starlink.auth.BadChallengeException;
import uk.ac.starlink.auth.Challenge;
import uk.ac.starlink.auth.ContextFactory;
import uk.ac.starlink.auth.IvoaAuthScheme;
import uk.ac.starlink.auth.LoginProtocol;
import uk.ac.starlink.auth.ProtectionSpace;
import uk.ac.starlink.auth.UserInterface;

public class BearerIvoaAuthScheme
extends IvoaAuthScheme {
    public static final BearerIvoaAuthScheme INSTANCE = new BearerIvoaAuthScheme();
    public static final String SCHEME_NAME = "ivoa_bearer";
    public static final String TOKEN_HEADER = "X-VO-Bearer";

    private BearerIvoaAuthScheme() {
        super(SCHEME_NAME);
    }

    @Override
    public ContextFactory createContextFactory(final LoginProtocol loginProto, final URL loginUrl, URL challengeUrl) {
        final ProtectionSpace scope = new ProtectionSpace(challengeUrl, null);
        return new ContextFactory(){

            @Override
            public AuthContext createContext(UserInterface ui) {
                String token = IvoaAuthScheme.readAuth(loginProto, BearerIvoaAuthScheme.this, loginUrl, ui, x$0 -> BearerIvoaAuthScheme.readBearerToken(x$0));
                return token == null ? null : this.createBearerContext(token);
            }

            @Override
            public AuthContext createUnauthContext() {
                return this.createBearerContext(null);
            }

            private AuthContext createBearerContext(String token) {
                return new BearerContext(BearerIvoaAuthScheme.this, loginUrl.toString(), scope, token);
            }
        };
    }

    private static String readBearerToken(HttpURLConnection conn) throws IOException {
        String token = conn.getHeaderField(TOKEN_HEADER);
        conn.getInputStream().close();
        if (token == null || token.trim().length() == 0) {
            throw new IOException("No X-VO-Bearer field in login response");
        }
        return token;
    }

    private static class BearerContext
    implements AuthContext {
        private final BearerIvoaAuthScheme scheme_;
        private final String loginUrl_;
        private final ProtectionSpace scope_;
        private final String token_;

        BearerContext(BearerIvoaAuthScheme scheme, String loginUrl, ProtectionSpace scope, String token) {
            this.scheme_ = scheme;
            this.loginUrl_ = loginUrl;
            this.scope_ = scope;
            this.token_ = token;
        }

        @Override
        public AuthScheme getScheme() {
            return this.scheme_;
        }

        @Override
        public boolean hasCredentials() {
            return this.token_ != null;
        }

        @Override
        public boolean isUrlDomain(URL url) {
            return this.scope_.equals(new ProtectionSpace(url, null));
        }

        @Override
        public boolean isChallengeDomain(Challenge challenge, URL url) {
            try {
                return this.scheme_.createContextFactory(challenge, url) != null && this.loginUrl_.equals(challenge.getParams().get("access_url")) && this.scope_.equals(new ProtectionSpace(url, null));
            }
            catch (BadChallengeException e) {
                return false;
            }
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public void configureConnection(HttpURLConnection connection) throws IOException {
            if (this.token_ != null) {
                connection.setRequestProperty("Authorization", "Bearer " + this.token_);
            }
        }

        @Override
        public String[] getCurlArgs(URL url, boolean showSecrets) {
            String[] stringArray;
            if (this.token_ == null) {
                stringArray = new String[]{};
            } else {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "--header";
                stringArray = stringArray2;
                stringArray2[1] = "Authorization: Bearer " + this.token_;
            }
            return stringArray;
        }
    }
}

