/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.auth;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.LinkedHashMap;
import uk.ac.starlink.auth.AuthUtil;
import uk.ac.starlink.auth.BasicAuthScheme;
import uk.ac.starlink.auth.LoginProtocol;
import uk.ac.starlink.auth.UserPass;

public abstract class IvoaLoginProtocol
implements LoginProtocol {
    public static final String SSO_URL = "ivo://ivoa.net/sso";
    public static final IvoaLoginProtocol TLS_WITH_PASSWORD = new TlsWithPasswordProtocol();
    public static final IvoaLoginProtocol BASIC_AA = new BasicAaProtocol();
    private static final IvoaLoginProtocol[] INSTANCES = new IvoaLoginProtocol[]{TLS_WITH_PASSWORD, BASIC_AA};
    private final String stdId_;
    private final String name_;

    private IvoaLoginProtocol(String idFrag) {
        this.stdId_ = "ivo://ivoa.net/sso#" + idFrag;
        this.name_ = idFrag;
    }

    public String getStandardId() {
        return this.stdId_;
    }

    @Override
    public String getProtocolName() {
        return this.name_;
    }

    public static IvoaLoginProtocol getProtocol(String stdId) {
        for (IvoaLoginProtocol proto : INSTANCES) {
            if (!proto.stdId_.equalsIgnoreCase(stdId)) continue;
            return proto;
        }
        return null;
    }

    private static HttpURLConnection openHttpConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            return (HttpURLConnection)conn;
        }
        throw new IOException("Not HTTP URL: " + url);
    }

    private static class BasicAaProtocol
    extends IvoaLoginProtocol {
        private static final String BASIC = "Basic";

        BasicAaProtocol() {
            super("BasicAA");
        }

        @Override
        public HttpURLConnection presentCredentials(URL url, UserPass userpass) throws IOException {
            HttpURLConnection conn = IvoaLoginProtocol.openHttpConnection(url);
            String userpass64 = BasicAuthScheme.encodeUserPass(userpass.getUsername(), userpass.getPassword());
            conn.setRequestProperty("Authorization", "Basic " + userpass64);
            conn.getResponseCode();
            return conn;
        }
    }

    private static class TlsWithPasswordProtocol
    extends IvoaLoginProtocol {
        private static final String PASSWORD = "password";
        private static final String USERNAME = "username";

        TlsWithPasswordProtocol() {
            super("tls-with-password");
        }

        @Override
        public HttpURLConnection presentCredentials(URL url, UserPass userpass) throws IOException {
            LinkedHashMap<String, String> postParams = new LinkedHashMap<String, String>();
            postParams.put(USERNAME, userpass.getUsername());
            postParams.put(PASSWORD, new String(userpass.getPassword()));
            HttpURLConnection conn = IvoaLoginProtocol.openHttpConnection(url);
            AuthUtil.postForm(conn, postParams);
            conn.getResponseCode();
            return conn;
        }
    }
}

