/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.logging.Logger;
import uk.ac.bristol.star.feather.ColStat;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.bristol.star.feather.FeatherWriter;
import uk.ac.starlink.feather.ItemAccumulator;
import uk.ac.starlink.feather.StarColumnWriter;
import uk.ac.starlink.feather.StarColumnWriters;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.formats.DocumentedIOHandler;
import uk.ac.starlink.table.formats.DocumentedStreamStarTableWriter;
import uk.ac.starlink.util.IntList;

public class FeatherTableWriter
extends DocumentedStreamStarTableWriter {
    private final boolean isColumnOrder_;
    private final StoragePolicy storage_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.feather");

    public FeatherTableWriter() {
        this(false, StoragePolicy.getDefaultPolicy());
    }

    public FeatherTableWriter(boolean isColumnOrder, StoragePolicy storage) {
        super(new String[]{"fea", "feather"});
        this.isColumnOrder_ = isColumnOrder;
        this.storage_ = storage;
    }

    public String getFormatName() {
        return "feather";
    }

    public String getMimeType() {
        return "application/octet-stream";
    }

    public boolean docIncludesExample() {
        return false;
    }

    public String getXmlDescription() {
        return String.join((CharSequence)"\n", "<p>The Feather file format is a column-oriented binary", "disk-based format based on Apache Arrow", "and supported by (at least) Python, R and Julia.", "Some description of it is available at", DocumentedIOHandler.toLink((String)"https://github.com/wesm/feather"), "and", DocumentedIOHandler.toLink((String)"https://blog.rstudio.com/2016/03/29/feather/") + ".", "It can be used for large datasets, but it does not support", "array-valued columns.", "It can be a useful format to use for exchanging data with R,", "for which FITS I/O is reported to be slow.", "</p>", "<p>This writer is somewhat experimental;", "please report problems if you encounter them.", "</p>", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeStarTable(StarTable table, OutputStream out) throws IOException {
        String description = table.getName();
        String tableMeta = null;
        int ncol = table.getColumnCount();
        ArrayList<StarColumnWriter> cwList = new ArrayList<StarColumnWriter>();
        IntList icList = new IntList();
        for (int ic = 0; ic < ncol; ++ic) {
            StarColumnWriter writer = StarColumnWriters.createColumnWriter(table, ic);
            if (writer != null) {
                icList.add(ic);
                cwList.add(writer);
                continue;
            }
            logger_.warning("Can't encode column " + table.getColumnInfo(ic) + " to " + this.getFormatName() + " format");
        }
        ItemAccumulator[] accumulators = null;
        try {
            FeatherColumnWriter[] colWriters;
            if (this.isColumnOrder_) {
                colWriters = cwList.toArray(new FeatherColumnWriter[0]);
            } else {
                int[] ics = icList.toIntArray();
                int nic = ics.length;
                accumulators = new ItemAccumulator[nic];
                for (int jc = 0; jc < nic; ++jc) {
                    int ic = ics[jc];
                    accumulators[jc] = ((StarColumnWriter)cwList.get(jc)).createItemAccumulator(this.storage_);
                }
                try (RowSequence rseq = table.getRowSequence();){
                    while (rseq.next()) {
                        Object[] row = rseq.getRow();
                        for (int jc = 0; jc < nic; ++jc) {
                            int ic = ics[jc];
                            accumulators[jc].addItem(row[ic]);
                        }
                    }
                }
                colWriters = new FeatherColumnWriter[nic];
                for (int jc = 0; jc < nic; ++jc) {
                    final FeatherColumnWriter cw = (FeatherColumnWriter)cwList.get(jc);
                    final ItemAccumulator acc = accumulators[jc];
                    colWriters[jc] = new FeatherColumnWriter(){

                        @Override
                        public FeatherType getFeatherType() {
                            return cw.getFeatherType();
                        }

                        @Override
                        public String getName() {
                            return cw.getName();
                        }

                        @Override
                        public String getUserMetadata() {
                            return cw.getUserMetadata();
                        }

                        @Override
                        public ColStat writeColumnBytes(OutputStream out) throws IOException {
                            return acc.writeColumnBytes(out);
                        }
                    };
                }
            }
            new FeatherWriter(description, tableMeta, colWriters).write(out);
        }
        finally {
            if (accumulators != null) {
                for (ItemAccumulator acc : accumulators) {
                    acc.close();
                }
            }
        }
    }
}

