/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.feather;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.starlink.feather.AbstractItemAccumulator;
import uk.ac.starlink.feather.ItemAccumulator;
import uk.ac.starlink.feather.StarColumnWriter;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;

public abstract class VariableStarColumnWriter
extends StarColumnWriter {
    private final PointerSize psize_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.feather");

    protected VariableStarColumnWriter(StarTable table, int icol, FeatherType ftype, boolean isNullable, PointerSize psize) {
        super(table, icol, ftype, isNullable);
        this.psize_ = psize;
    }

    public abstract int getItemSize(Object var1);

    public abstract int writeItemBytes(OutputStream var1, Object var2) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarColumnWriter.DataStat writeDataBytes(OutputStream out) throws IOException {
        IndexStatus ixStat;
        int icol = this.getColumnIndex();
        try (RowSequence irseq = this.getTable().getRowSequence();){
            ixStat = this.writeOffsets(out, irseq);
        }
        long ixb = (long)this.psize_.nbyte_ * (ixStat.rowCount_ + 1L);
        long indexBytes = ixb + (long)BufUtils.align8(out, ixb);
        long entryLimit = ixStat.entryCount_;
        try (RowSequence drseq = this.getTable().getRowSequence();){
            for (long ir = 0L; drseq.next() && ir < entryLimit; ++ir) {
                this.writeItemBytes(out, drseq.getCell(icol));
            }
        }
        long db = ixStat.byteCount_;
        long dataBytes = db + (long)BufUtils.align8(out, db);
        long nbyte = indexBytes + dataBytes;
        long nrow = ixStat.rowCount_;
        return new StarColumnWriter.DataStat(nbyte, nrow);
    }

    @Override
    public ItemAccumulator createItemAccumulator(StoragePolicy storage) {
        final ByteStore indexStore = storage.makeByteStore();
        final ByteStore dataStore = storage.makeByteStore();
        final BufferedOutputStream indexOut = new BufferedOutputStream(indexStore.getOutputStream());
        final BufferedOutputStream dataOut = new BufferedOutputStream(dataStore.getOutputStream());
        return new AbstractItemAccumulator(storage, this.isNullable()){
            long ioff;
            boolean hasOverflowed;
            long nrow;

            @Override
            public void addDataItem(Object item) throws IOException {
                ++this.nrow;
                VariableStarColumnWriter.this.psize_.writeOffset(indexOut, this.ioff);
                long ioff1 = this.ioff + (long)VariableStarColumnWriter.this.writeItemBytes(dataOut, item);
                if (!VariableStarColumnWriter.this.psize_.isOverflow(ioff1)) {
                    this.ioff = ioff1;
                } else if (!this.hasOverflowed) {
                    this.hasOverflowed = true;
                    logger_.warning("Pointer overflow - empty values in column " + VariableStarColumnWriter.this.getTable().getColumnInfo(VariableStarColumnWriter.this.getColumnIndex()).getName() + " past row " + this.nrow);
                }
            }

            @Override
            public long writeDataBytes(OutputStream out) throws IOException {
                VariableStarColumnWriter.this.psize_.writeOffset(indexOut, this.ioff);
                long ixb = (long)((VariableStarColumnWriter)VariableStarColumnWriter.this).psize_.nbyte_ * (this.nrow + 1L);
                long indexBytes = ixb + (long)BufUtils.align8(indexOut, ixb);
                indexOut.close();
                indexStore.copy(out);
                indexStore.close();
                dataOut.close();
                dataStore.copy(out);
                dataStore.close();
                return indexBytes + this.ioff;
            }

            @Override
            public void closeData() throws IOException {
                indexOut.close();
                indexStore.close();
                dataOut.close();
                dataStore.close();
            }
        };
    }

    private IndexStatus writeOffsets(OutputStream out, RowSequence rseq) throws IOException {
        int icol = this.getColumnIndex();
        long nrow = 0L;
        long ioff = 0L;
        while (rseq.next()) {
            this.psize_.writeOffset(out, ioff);
            long ioff1 = ioff + (long)this.getItemSize(rseq.getCell(icol));
            if (this.psize_.isOverflow(ioff1)) {
                logger_.warning("Pointer overflow - empty values in column " + this.getTable().getColumnInfo(icol).getName() + " past row " + nrow);
                long entryCount = nrow;
                do {
                    this.psize_.writeOffset(out, ioff);
                    ++nrow;
                } while (rseq.next());
                return new IndexStatus(nrow, entryCount, ioff);
            }
            ioff = ioff1;
            ++nrow;
        }
        this.psize_.writeOffset(out, ioff);
        return new IndexStatus(nrow, nrow, ioff);
    }

    public static VariableStarColumnWriter createStringWriter(StarTable table, int icol, boolean isNullable, PointerSize psize) {
        return new VariableStarColumnWriter(table, icol, psize.utf8Type_, isNullable, psize){

            @Override
            public int getItemSize(Object item) {
                return item == null ? 0 : BufUtils.utf8Length(item.toString());
            }

            @Override
            public int writeItemBytes(OutputStream out, Object item) throws IOException {
                if (item != null) {
                    byte[] bytes = item.toString().getBytes(BufUtils.UTF8);
                    out.write(bytes);
                    return bytes.length;
                }
                return 0;
            }
        };
    }

    public static VariableStarColumnWriter createByteArrayWriter(StarTable table, int icol, boolean isNullable, PointerSize psize) {
        return new VariableStarColumnWriter(table, icol, psize.binaryType_, isNullable, psize){

            @Override
            public int getItemSize(Object item) {
                return item instanceof byte[] ? ((byte[])item).length : 0;
            }

            @Override
            public int writeItemBytes(OutputStream out, Object item) throws IOException {
                if (item instanceof byte[]) {
                    byte[] bytes = (byte[])item;
                    out.write(bytes);
                    return bytes.length;
                }
                return 0;
            }
        };
    }

    private static class IndexStatus {
        final long rowCount_;
        final long entryCount_;
        final long byteCount_;

        IndexStatus(long rowCount, long entryCount, long byteCount) {
            this.rowCount_ = rowCount;
            this.entryCount_ = entryCount;
            this.byteCount_ = byteCount;
        }
    }

    public static enum PointerSize {
        I32(4, FeatherType.UTF8, FeatherType.BINARY){

            @Override
            void writeOffset(OutputStream out, long ioff) throws IOException {
                BufUtils.writeLittleEndianInt(out, (int)ioff);
            }

            @Override
            boolean isOverflow(long ioff) {
                return ioff >= Integer.MAX_VALUE;
            }
        }
        ,
        I64(8, FeatherType.LARGE_UTF8, FeatherType.LARGE_BINARY){

            @Override
            void writeOffset(OutputStream out, long ioff) throws IOException {
                BufUtils.writeLittleEndianLong(out, ioff);
            }

            @Override
            boolean isOverflow(long ioff) {
                return false;
            }
        };

        final int nbyte_;
        final FeatherType utf8Type_;
        final FeatherType binaryType_;

        private PointerSize(int nbyte, FeatherType utf8Type, FeatherType binaryType) {
            this.nbyte_ = nbyte;
            this.utf8Type_ = utf8Type;
            this.binaryType_ = binaryType;
        }

        abstract void writeOffset(OutputStream var1, long var2) throws IOException;

        abstract boolean isOverflow(long var1);
    }
}

