/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.function.DoubleFunction;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BasicInputThreadLocal;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;

public abstract class AsciiTableStarTable
extends AbstractStarTable {
    private final long nrow_;
    private final int ncol_;
    private final int rowLeng_;
    private final ColumnInfo[] colInfos_;
    private final int[] icOffs_;
    private final int[] icLengs_;
    private final String[] trimNulls_;
    private final AsciiColumnReader<?>[] colReaders_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");
    private static final Pattern TFORM_REGEX = Pattern.compile(" *([AIFED])([0-9]+)(?:\\.([0-9]+))? *");
    private static final Pattern INT_REGEX = Pattern.compile("([+-]?) *([0-9]+)");
    private static final Pattern FLOAT_REGEX = Pattern.compile("([+-]?(?:[0-9]*\\.[0-9]*|[0-9]+\\.?))[ED]?([+-]?[0-9]+)?");

    public AsciiTableStarTable(FitsHeader hdr) throws IOException {
        if (!hdr.getStringValue("XTENSION").equals("TABLE")) {
            throw new TableFormatException("Not an ASCII TABLE extension");
        }
        this.rowLeng_ = hdr.getRequiredIntValue("NAXIS1");
        this.nrow_ = hdr.getRequiredLongValue("NAXIS2");
        this.ncol_ = hdr.getRequiredIntValue("TFIELDS");
        if (this.ncol_ > 999) {
            throw new TableFormatException("TFIELDS > 999 (" + this.ncol_ + ")");
        }
        this.colInfos_ = new ColumnInfo[this.ncol_];
        this.icOffs_ = new int[this.ncol_];
        this.icLengs_ = new int[this.ncol_];
        this.trimNulls_ = new String[this.ncol_];
        this.colReaders_ = new AsciiColumnReader[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String trimNull;
            Double tscal;
            String tunit;
            ColumnInfo cinfo;
            int jcol = icol + 1;
            this.colInfos_[icol] = cinfo = new ColumnInfo("col" + jcol);
            int tbcol = hdr.getRequiredIntValue("TBCOL" + jcol);
            String tform = hdr.getRequiredStringValue("TFORM" + jcol);
            String ttype = hdr.getStringValue("TTYPE" + jcol);
            if (ttype != null) {
                cinfo.setName(ttype);
            }
            if ((tunit = hdr.getStringValue("TUNIT" + jcol)) != null) {
                cinfo.setUnitString(tunit);
            }
            double scale = (tscal = hdr.getDoubleValue("TSCAL" + jcol)) == null ? 1.0 : tscal;
            Double tzero = hdr.getDoubleValue("TZERO" + jcol);
            double zero = tzero == null ? 0.0 : tzero;
            String tnull = hdr.getStringValue("TNULL" + jcol);
            String string = trimNull = tnull == null ? null : tnull.trim();
            if (trimNull != null && trimNull.length() > 0) {
                this.trimNulls_[icol] = trimNull;
            } else if (tform.trim().startsWith("I")) {
                cinfo.setNullable(false);
            }
            this.icOffs_[icol] = tbcol - 1;
            AsciiColumnReader<?> crdr = AsciiTableStarTable.createColumnReader(tform, scale, zero);
            this.icLengs_[icol] = crdr.getFieldWidth();
            cinfo.setContentClass(crdr.getValueClass());
            this.colReaders_[icol] = crdr;
        }
        String extname = hdr.getStringValue("EXTNAME");
        if (extname != null) {
            String tname = extname;
            String extver = hdr.getStringValue("EXTVER");
            if (extver != null) {
                tname = tname + "-" + extver;
            }
            this.setName(tname);
        }
        this.getParameters().addAll(Arrays.asList(hdr.getUnusedParams()));
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public int getColumnCount() {
        return this.ncol_;
    }

    @Override
    public ColumnInfo getColumnInfo(int icol) {
        return this.colInfos_[icol];
    }

    protected int getRowLength() {
        return this.rowLeng_;
    }

    protected int[] getColumnOffsets() {
        return this.icOffs_;
    }

    protected int[] getColumnLengths() {
        return this.icLengs_;
    }

    protected Object[] readRow(byte[] rowBuf) {
        String rowTxt = new String(rowBuf, StandardCharsets.US_ASCII);
        Object[] row = new Object[this.ncol_];
        for (int icol = 0; icol < this.ncol_; ++icol) {
            String cellTxt = AsciiTableStarTable.trimSequence(rowTxt, this.icOffs_[icol], this.icLengs_[icol]);
            String trimNull = this.trimNulls_[icol];
            row[icol] = trimNull != null && trimNull.equals(cellTxt) ? null : this.colReaders_[icol].readValue(cellTxt);
        }
        return row;
    }

    protected Object readCell(byte[] cellBuf, int icol) {
        int leng = this.icLengs_[icol];
        String cellTxt = AsciiTableStarTable.trimSequence(new String(cellBuf, StandardCharsets.US_ASCII), 0, leng);
        String trimNull = this.trimNulls_[icol];
        return trimNull != null && trimNull.equals(cellTxt) ? null : this.colReaders_[icol].readValue(cellTxt);
    }

    public static AsciiTableStarTable createTable(FitsHeader hdr, InputFactory inputFact) throws IOException {
        return inputFact.isRandom() ? new RandomAsciiTableStarTable(hdr, inputFact) : new SequentialAsciiTableStarTable(hdr, inputFact);
    }

    public static void streamStarTable(FitsHeader hdr, BasicInput input, TableSink sink) throws IOException {
        InputFactory dummyFact = new InputFactory(){

            @Override
            public boolean isRandom() {
                return false;
            }

            @Override
            public BasicInput createInput(boolean isSeq) {
                throw new UnsupportedOperationException("Metadata only");
            }

            @Override
            public void close() {
            }
        };
        SequentialAsciiTableStarTable meta = new SequentialAsciiTableStarTable(hdr, dummyFact);
        sink.acceptMetadata(meta);
        long nrow = meta.getRowCount();
        int rowLeng = meta.getRowLength();
        byte[] rowBuf = new byte[rowLeng];
        for (long i = 0L; i < nrow; ++i) {
            input.readBytes(rowBuf);
            Object[] row = meta.readRow(rowBuf);
            sink.acceptRow(row);
        }
        sink.endRows();
        long datasize = nrow * (long)meta.getRowLength();
        int over = (int)(datasize % 2880L);
        if (over > 0) {
            input.skip(over);
        }
    }

    private static String trimSequence(String txt, int ioff, int leng) {
        int iend = ioff + leng;
        int i0 = ioff;
        int i1 = iend;
        for (int i = ioff; i < iend; ++i) {
            char c = txt.charAt(i);
            if (c == ' ') {
                if (i0 != i) continue;
                ++i0;
                continue;
            }
            i1 = i + 1;
        }
        return i1 > i0 ? txt.substring(i0, i1) : "";
    }

    private static AsciiColumnReader<?> createColumnReader(String tform, double scale, double zero) {
        int dplace;
        Matcher matcher = TFORM_REGEX.matcher(tform);
        if (!matcher.matches()) {
            logger_.warning("Illegal TFORM \"" + tform + "\"");
            return AsciiTableStarTable.createReader(Void.class, 0, txt -> null);
        }
        char fmtChar = matcher.group(1).charAt(0);
        int width = Integer.parseInt(matcher.group(2));
        String dTxt = matcher.group(3);
        int n = dplace = dTxt == null ? 0 : Integer.parseInt(dTxt);
        if (fmtChar == 'A') {
            return AsciiTableStarTable.createReader(String.class, width, txt -> txt);
        }
        if (fmtChar == 'I') {
            if (scale == 1.0 && zero == 0.0) {
                if (width < 10) {
                    return AsciiTableStarTable.createIntReader(Integer.class, width, lval -> (int)lval);
                }
                return AsciiTableStarTable.createIntReader(Long.class, width, lval -> lval);
            }
            return AsciiTableStarTable.createIntReader(Double.class, width, lval -> (double)lval * scale + zero);
        }
        if (fmtChar == 'D' || fmtChar == 'E' || fmtChar == 'F') {
            if (scale == 1.0 && zero == 0.0) {
                if (width < 8) {
                    return AsciiTableStarTable.createFloatingReader(Float.class, width, dplace, d -> Float.valueOf((float)d));
                }
                return AsciiTableStarTable.createFloatingReader(Double.class, width, dplace, d -> d);
            }
            return AsciiTableStarTable.createFloatingReader(Double.class, width, dplace, d -> d * scale + zero);
        }
        logger_.warning("Illegal TFORM \"" + tform + "\"");
        return AsciiTableStarTable.createReader(Void.class, 0, txt -> null);
    }

    private static <T> AsciiColumnReader<T> createIntReader(Class<T> clazz, int width, LongFunction<T> fromLong) {
        return AsciiTableStarTable.createReader(clazz, width, txt -> {
            if (txt.length() == 0) {
                return fromLong.apply(0L);
            }
            Matcher intMatcher = INT_REGEX.matcher((CharSequence)txt);
            if (intMatcher.matches()) {
                long val;
                try {
                    val = Long.parseLong(intMatcher.group(2));
                }
                catch (NumberFormatException e) {
                    return null;
                }
                long sval = "-".equals(intMatcher.group(1)) ? -val : val;
                return fromLong.apply(sval);
            }
            return null;
        });
    }

    private static <T> AsciiColumnReader<T> createFloatingReader(Class<T> clazz, int width, int dplace, DoubleFunction<T> fromDouble) {
        double implicitFactor = Math.pow(10.0, -dplace);
        return AsciiTableStarTable.createReader(clazz, width, txt -> {
            Matcher floatMatcher = FLOAT_REGEX.matcher((CharSequence)txt);
            if (floatMatcher.matches()) {
                double dval;
                String mantissa = floatMatcher.group(1);
                String exponent = floatMatcher.group(2);
                String numTxt = exponent == null ? mantissa : mantissa + "E" + exponent;
                try {
                    dval = Double.parseDouble(numTxt);
                }
                catch (NumberFormatException e) {
                    return null;
                }
                if (mantissa.indexOf(46) < 0) {
                    dval *= implicitFactor;
                }
                return fromDouble.apply(dval);
            }
            return null;
        });
    }

    private static <T> AsciiColumnReader<T> createReader(final Class<T> clazz, final int width, final Function<String, T> read) {
        return new AsciiColumnReader<T>(){

            @Override
            public Class<T> getValueClass() {
                return clazz;
            }

            @Override
            public int getFieldWidth() {
                return width;
            }

            @Override
            public T readValue(String trimTxt) {
                return read.apply(trimTxt);
            }
        };
    }

    private static class RandomAsciiTableStarTable
    extends AsciiTableStarTable {
        private final InputFactory inputFact_;
        private final BasicInputThreadLocal randomInputThreadLocal_;
        private final int rowLength_;
        private final int[] colOffsets_;
        private final int[] colLengths_;

        RandomAsciiTableStarTable(FitsHeader hdr, InputFactory inputFact) throws IOException {
            super(hdr);
            this.inputFact_ = inputFact;
            if (!inputFact.isRandom()) {
                throw new IllegalArgumentException("not random");
            }
            this.rowLength_ = this.getRowLength();
            this.colOffsets_ = this.getColumnOffsets();
            this.colLengths_ = this.getColumnLengths();
            this.randomInputThreadLocal_ = new BasicInputThreadLocal(inputFact, false);
        }

        @Override
        public boolean isRandom() {
            return true;
        }

        @Override
        public Object getCell(long lrow, int icol) throws IOException {
            BasicInput randomInput = (BasicInput)this.randomInputThreadLocal_.get();
            randomInput.seek(lrow * (long)this.rowLength_ + (long)this.colOffsets_[icol]);
            byte[] cellBuf = new byte[this.colLengths_[icol]];
            randomInput.readBytes(cellBuf);
            return this.readCell(cellBuf, icol);
        }

        @Override
        public Object[] getRow(long lrow) throws IOException {
            BasicInput randomInput = (BasicInput)this.randomInputThreadLocal_.get();
            randomInput.seek(lrow * (long)this.rowLength_);
            byte[] rowBuf = new byte[this.rowLength_];
            randomInput.readBytes(rowBuf);
            return this.readRow(rowBuf);
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final BasicInput input = this.inputFact_.createInput(true);
            assert (input.isRandom());
            final long endPos = this.getRowCount() * (long)this.rowLength_;
            final byte[] rowBuf = new byte[this.rowLength_];
            int ncol = this.getColumnCount();
            final byte[][] cellBufs = new byte[ncol][];
            for (int ic = 0; ic < ncol; ++ic) {
                cellBufs[ic] = new byte[this.colLengths_[ic]];
            }
            return new RowSequence(){
                long pos;
                {
                    this.pos = -rowLength_;
                }

                @Override
                public boolean next() {
                    this.pos += (long)rowLength_;
                    return this.pos < endPos;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    if (this.pos >= 0L && this.pos < endPos) {
                        input.seek(this.pos + (long)colOffsets_[icol]);
                        byte[] cellBuf = cellBufs[icol];
                        input.readBytes(cellBuf);
                        return this.readCell(cellBuf, icol);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.pos >= 0L && this.pos < endPos) {
                        input.seek(this.pos);
                        input.readBytes(rowBuf);
                        return this.readRow(rowBuf);
                    }
                    throw new IllegalStateException();
                }

                @Override
                public void close() throws IOException {
                    input.close();
                }
            };
        }

        @Override
        public RowAccess getRowAccess() throws IOException {
            final BasicInput input = this.inputFact_.createInput(false);
            assert (input.isRandom());
            final byte[] rowBuf = new byte[this.rowLength_];
            int ncol = this.getColumnCount();
            final byte[][] cellBufs = new byte[ncol][];
            for (int ic = 0; ic < ncol; ++ic) {
                cellBufs[ic] = new byte[this.colLengths_[ic]];
            }
            return new RowAccess(){
                long irow_ = -1L;

                @Override
                public void setRowIndex(long irow) {
                    this.irow_ = irow;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    input.seek(this.irow_ * (long)rowLength_ + (long)colOffsets_[icol]);
                    byte[] cellBuf = cellBufs[icol];
                    input.readBytes(cellBuf);
                    return this.readCell(cellBuf, icol);
                }

                @Override
                public Object[] getRow() throws IOException {
                    input.seek(this.irow_ * (long)rowLength_);
                    input.readBytes(rowBuf);
                    return this.readRow(rowBuf);
                }

                @Override
                public void close() throws IOException {
                    input.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.randomInputThreadLocal_.close();
            this.inputFact_.close();
        }
    }

    private static class SequentialAsciiTableStarTable
    extends AsciiTableStarTable {
        private final InputFactory inputFact_;

        SequentialAsciiTableStarTable(FitsHeader hdr, InputFactory inputFact) throws IOException {
            super(hdr);
            this.inputFact_ = inputFact;
        }

        @Override
        public RowSequence getRowSequence() throws IOException {
            final BasicInput input = this.inputFact_.createInput(true);
            final Object[] beforeStart = new Object[]{};
            final long nrow = this.getRowCount();
            final int rowLength = this.getRowLength();
            final byte[] rowBuf = new byte[rowLength];
            return new RowSequence(){
                long lrow_ = -1L;
                Object[] row_ = beforeStart;
                long nskip_ = 0L;

                @Override
                public boolean next() throws IOException {
                    if (this.lrow_ < nrow - 1L) {
                        if (this.row_ == null) {
                            this.nskip_ += (long)rowLength;
                        }
                        this.row_ = null;
                        ++this.lrow_;
                        return true;
                    }
                    return false;
                }

                @Override
                public Object getCell(int icol) throws IOException {
                    return this.getRow()[icol];
                }

                @Override
                public Object[] getRow() throws IOException {
                    if (this.row_ == beforeStart) {
                        throw new IllegalStateException();
                    }
                    if (this.row_ == null) {
                        if (this.nskip_ != 0L) {
                            input.skip(this.nskip_);
                            this.nskip_ = 0L;
                        }
                        input.readBytes(rowBuf);
                        this.row_ = this.readRow(rowBuf);
                    }
                    return this.row_;
                }

                @Override
                public void close() throws IOException {
                    if (this.nskip_ != 0L) {
                        input.skip(this.nskip_);
                        this.nskip_ = 0L;
                    }
                    input.close();
                }
            };
        }

        @Override
        public void close() throws IOException {
            this.inputFact_.close();
        }
    }

    private static interface AsciiColumnReader<T> {
        public Class<T> getValueClass();

        public int getFieldWidth();

        public T readValue(String var1);
    }
}

