/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.InputFactory;

public class BasicInputThreadLocal
extends ThreadLocal<BasicInput>
implements Closeable {
    private final InputFactory inputFact_;
    private final boolean isSeq_;
    private final List<BasicInput> inputs_;

    public BasicInputThreadLocal(InputFactory inputFact, boolean isSeq) {
        this.inputFact_ = inputFact;
        this.isSeq_ = isSeq;
        this.inputs_ = new ArrayList<BasicInput>();
    }

    @Override
    protected BasicInput initialValue() {
        BasicInput bi = this.createBasicInput();
        this.inputs_.add(bi);
        return bi;
    }

    private BasicInput createBasicInput() {
        try {
            return this.inputFact_.createInput(this.isSeq_);
        }
        catch (IOException e) {
            return new FailureBasicInput(e, this.isSeq_);
        }
    }

    @Override
    public synchronized void close() {
        Iterator<BasicInput> it = this.inputs_.iterator();
        while (it.hasNext()) {
            try {
                it.next().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            it.remove();
        }
    }

    private static class FailureBasicInput
    implements BasicInput {
        private final IOException err_;
        private final boolean isSeq_;

        FailureBasicInput(IOException err, boolean isSeq) {
            this.isSeq_ = isSeq;
            this.err_ = err;
        }

        @Override
        public byte readByte() throws IOException {
            throw this.failure();
        }

        @Override
        public short readShort() throws IOException {
            throw this.failure();
        }

        @Override
        public int readInt() throws IOException {
            throw this.failure();
        }

        @Override
        public long readLong() throws IOException {
            throw this.failure();
        }

        @Override
        public float readFloat() throws IOException {
            throw this.failure();
        }

        @Override
        public double readDouble() throws IOException {
            throw this.failure();
        }

        @Override
        public void readBytes(byte[] bbuf) throws IOException {
            throw this.failure();
        }

        @Override
        public void skip(long nbyte) throws IOException {
            throw this.failure();
        }

        @Override
        public boolean isRandom() {
            return this.isSeq_;
        }

        @Override
        public void seek(long offset) throws IOException {
            throw this.failure();
        }

        @Override
        public long getOffset() {
            return 0L;
        }

        @Override
        public void close() {
        }

        private IOException failure() {
            return (IOException)new IOException("Input creation failed").initCause(this.err_);
        }
    }
}

