/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.nio.ByteBuffer;
import uk.ac.starlink.fits.BlockInput;
import uk.ac.starlink.fits.BlockManager;

public abstract class BlockMappedInput
extends BlockInput {
    private final BlockManager blockManager_;
    private final long blockSize_;
    private final int nblock_;
    public static final long DEFAULT_EXPIRYMILLIS = 20000L;

    protected BlockMappedInput(BlockManager blockManager) {
        super(blockManager.getBlockCount());
        this.blockManager_ = blockManager;
        this.nblock_ = blockManager.getBlockCount();
        this.blockSize_ = blockManager.getBlockSize();
    }

    @Override
    public int[] getBlockPos(long offset) {
        return new int[]{(int)(offset / this.blockSize_), (int)(offset % this.blockSize_)};
    }

    @Override
    public long getBlockOffset(int iblock, int offsetInBlock) {
        return (long)iblock * this.blockSize_ + (long)offsetInBlock;
    }

    @Override
    public void close() {
        super.close();
    }

    ByteBuffer createBuffer(int iblock) throws IOException {
        return this.blockManager_.getBufferManager(iblock).createBuffer();
    }

    void disposeBuffer(int iblock, ByteBuffer buf) {
        if (iblock >= 0) {
            this.blockManager_.getBufferManager(iblock).disposeBuffer(buf);
        }
    }

    public static BlockMappedInput createInput(BlockManager blockManager, boolean caching) throws IOException {
        return BlockMappedInput.createInput(blockManager, caching ? 20000L : 0L);
    }

    public static BlockMappedInput createInput(BlockManager blockManager, long expiryMillis) throws IOException {
        return expiryMillis > 0L ? new CachingBlockMappedInput(blockManager, expiryMillis) : new UniqueBlockMappedInput(blockManager);
    }

    private static class CachingBlockMappedInput
    extends BlockMappedInput {
        private final int nblock_;
        private final long expiryMillis_;
        private final long tidyMillis_;
        private final ByteBuffer[] bufs_;
        private final long[] useEpochs_;
        private long lastTidy_;

        public CachingBlockMappedInput(BlockManager blockManager, long expiryMillis) {
            super(blockManager);
            this.expiryMillis_ = expiryMillis;
            this.tidyMillis_ = expiryMillis / 4L;
            this.nblock_ = this.getBlockCount();
            this.bufs_ = new ByteBuffer[this.nblock_];
            this.useEpochs_ = new long[this.nblock_];
            this.lastTidy_ = System.currentTimeMillis();
        }

        @Override
        protected ByteBuffer acquireBlock(int iblock) throws IOException {
            ByteBuffer buf = this.bufs_[iblock];
            if (buf == null) {
                buf = this.createBuffer(iblock);
                long now = System.currentTimeMillis();
                if (now - this.lastTidy_ > this.tidyMillis_) {
                    this.tidyCache(now - this.expiryMillis_);
                    this.lastTidy_ = now;
                }
                this.bufs_[iblock] = buf;
                this.useEpochs_[iblock] = now;
            } else {
                buf.position(0);
            }
            return buf;
        }

        @Override
        public void close() {
            super.close();
            this.tidyCache(Long.MAX_VALUE);
        }

        private void tidyCache(long lastOkUse) {
            for (int i = 0; i < this.nblock_; ++i) {
                ByteBuffer buf = this.bufs_[i];
                long useEpoch = this.useEpochs_[i];
                if (buf == null || useEpoch >= lastOkUse) continue;
                this.bufs_[i] = null;
                this.disposeBuffer(i, buf);
            }
        }
    }

    private static class UniqueBlockMappedInput
    extends BlockMappedInput {
        private int iblock_;
        private ByteBuffer buffer_;

        public UniqueBlockMappedInput(BlockManager blockManager) {
            super(blockManager);
        }

        @Override
        protected ByteBuffer acquireBlock(int iblock) throws IOException {
            int oldIndex = this.iblock_;
            ByteBuffer oldBuffer = this.buffer_;
            if (oldBuffer != null) {
                this.disposeBuffer(oldIndex, oldBuffer);
            }
            this.buffer_ = this.createBuffer(iblock);
            this.iblock_ = iblock;
            return this.buffer_;
        }

        @Override
        public void close() {
            super.close();
            int oldIndex = this.iblock_;
            ByteBuffer oldBuffer = this.buffer_;
            if (oldBuffer != null) {
                this.iblock_ = -1;
                this.buffer_ = null;
                this.disposeBuffer(oldIndex, oldBuffer);
            }
        }
    }
}

