/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.fits.Unmapper;

public class BufferManager {
    private final FileChannel channel_;
    private final long offset_;
    private final int leng_;
    private final String logLabel_;
    private final Unmapper unmapper_;
    private final Map<ByteBuffer, Void> dupBuffers_;
    private MappedByteBuffer buffer0_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    public BufferManager(FileChannel channel, long offset, int leng, String logLabel, Unmapper unmapper) {
        this.channel_ = channel;
        this.offset_ = offset;
        this.leng_ = leng;
        this.logLabel_ = logLabel;
        this.unmapper_ = unmapper;
        this.dupBuffers_ = new IdentityHashMap<ByteBuffer, Void>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer createBuffer() throws IOException {
        ByteBuffer buf = this.getMappedBuffer().duplicate();
        assert (buf.position() == 0);
        assert (buf.isDirect());
        BufferManager bufferManager = this;
        synchronized (bufferManager) {
            this.dupBuffers_.put(buf, null);
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeBuffer(ByteBuffer buf) {
        boolean removed;
        BufferManager bufferManager = this;
        synchronized (bufferManager) {
            removed = this.dupBuffers_.keySet().remove(buf);
            if (this.dupBuffers_.isEmpty()) {
                this.unmapBuffer();
            }
        }
        if (!removed) {
            logger_.warning("Attempting to dispose unknown buffer " + this.logLabel_);
        }
    }

    public void close() {
        this.unmapBuffer();
    }

    private synchronized MappedByteBuffer getMappedBuffer() throws IOException {
        if (this.buffer0_ == null) {
            logger_.config("Mapping " + this.logLabel_);
            if (this.offset_ + (long)this.leng_ > this.channel_.size()) {
                String msg = "File too short mapping " + this.logLabel_ + " (" + this.channel_.size() + " < " + (this.offset_ + (long)this.leng_) + ") - truncated/corrupted?";
                throw new EOFException(msg);
            }
            this.buffer0_ = this.channel_.map(FileChannel.MapMode.READ_ONLY, this.offset_, this.leng_);
        }
        return this.buffer0_;
    }

    private synchronized void unmapBuffer() {
        if (this.buffer0_ != null) {
            boolean unmapped = this.unmapper_ == null ? false : this.unmapper_.unmap(this.buffer0_);
            this.buffer0_ = null;
            logger_.config("Dispose of mapped buffer " + this.logLabel_ + (unmapped ? " (unmapped)" : " (no effect)"));
        }
    }
}

