/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.EOFException;
import java.io.IOException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import uk.ac.starlink.fits.BasicInput;

public class ByteBufferInput
implements BasicInput {
    private final ByteBuffer niobuf_;

    public ByteBufferInput(ByteBuffer niobuf) {
        this.niobuf_ = niobuf;
    }

    @Override
    public boolean isRandom() {
        return true;
    }

    @Override
    public void seek(long pos) throws EOFException {
        int ipos = (int)pos;
        if ((long)ipos == pos) {
            try {
                this.niobuf_.position(ipos);
            }
            catch (IllegalArgumentException e) {
                if (ipos > this.niobuf_.limit()) {
                    throw (EOFException)new EOFException().initCause(e);
                }
                throw e;
            }
        } else {
            throw new EOFException("Out of bounds: " + pos);
        }
    }

    @Override
    public long getOffset() {
        return this.niobuf_.position();
    }

    @Override
    public void skip(long nbyte) throws IOException {
        this.seek(this.getOffset() + nbyte);
    }

    @Override
    public byte readByte() throws EOFException {
        try {
            return this.niobuf_.get();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public short readShort() throws EOFException {
        try {
            return this.niobuf_.getShort();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public int readInt() throws EOFException {
        try {
            return this.niobuf_.getInt();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public long readLong() throws EOFException {
        try {
            return this.niobuf_.getLong();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public float readFloat() throws EOFException {
        try {
            return this.niobuf_.getFloat();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public double readDouble() throws EOFException {
        try {
            return this.niobuf_.getDouble();
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public void readBytes(byte[] bbuf) throws EOFException {
        try {
            this.niobuf_.get(bbuf);
        }
        catch (BufferUnderflowException e) {
            throw (EOFException)new EOFException().initCause(e);
        }
    }

    @Override
    public void close() {
    }
}

