/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AbstractWideFits;
import uk.ac.starlink.fits.BintableColumnHeader;
import uk.ac.starlink.fits.CardFactory;
import uk.ac.starlink.fits.CardImage;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.ColumnStore;
import uk.ac.starlink.fits.FileColumnStore;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.FitsTableSerializerConfig;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;

public class ColFitsTableSerializer
implements FitsTableSerializer {
    private final FitsTableSerializerConfig config_;
    private final ColumnStore[] colStores_;
    private final String[] colids_;
    private final int ncol_;
    private final long nrow_;
    private final String tname_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.fits");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColFitsTableSerializer(FitsTableSerializerConfig config, StarTable table) throws IOException {
        this.config_ = config;
        this.tname_ = table.getName();
        this.ncol_ = table.getColumnCount();
        this.colStores_ = new ColumnStore[this.ncol_];
        this.colids_ = new String[this.ncol_];
        int nUseCol = 0;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnInfo info = table.getColumnInfo(icol);
            this.colids_[icol] = info.toString();
            this.colStores_[icol] = FileColumnStore.createColumnStore(info, config);
            if (this.colStores_[icol] == null) {
                logger_.warning("Can't serialize column " + info);
                continue;
            }
            ++nUseCol;
        }
        FitsUtil.checkColumnCount(config.getWide(), nUseCol);
        boolean ok = false;
        RowSequence rseq = table.getRowSequence();
        try {
            long lrow = 0L;
            while (rseq.next()) {
                Object[] row = rseq.getRow();
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    ColumnStore colStore = this.colStores_[icol];
                    if (colStore == null) continue;
                    colStore.storeValue(row[icol]);
                }
                ++lrow;
            }
            this.nrow_ = lrow;
            ok = true;
        }
        finally {
            rseq.close();
            if (!ok) {
                for (int icol = 0; icol < this.ncol_; ++icol) {
                    if (this.colStores_[icol] == null) continue;
                    this.colStores_[icol].dispose();
                }
            }
        }
        assert (ok);
        for (int icol = 0; icol < this.ncol_; ++icol) {
            if (this.colStores_[icol] == null || this.colStores_[icol] == null) continue;
            this.colStores_[icol].endStores();
        }
    }

    @Override
    public CardImage[] getHeader() {
        WideFits wide = this.config_.getWide();
        long size = 0L;
        long extSize = 0L;
        int nUseCol = 0;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnStore colStore = this.colStores_[icol];
            if (colStore == null) continue;
            long leng = colStore.getDataLength();
            size += leng;
            if (wide == null || ++nUseCol < wide.getContainerColumnIndex()) continue;
            extSize += leng;
        }
        int nStdCol = wide != null && nUseCol > wide.getContainerColumnIndex() ? wide.getContainerColumnIndex() : nUseCol;
        boolean hasExtCol = nUseCol > nStdCol;
        ArrayList<CardImage> cards = new ArrayList<CardImage>();
        CardFactory cfact = CardFactory.DEFAULT;
        cards.addAll(Arrays.asList(cfact.createStringCard("XTENSION", "BINTABLE", "binary table extension"), cfact.createIntegerCard("BITPIX", 8L, "8-bit bytes"), cfact.createIntegerCard("NAXIS", 2L, "2-dimensional table"), cfact.createIntegerCard("NAXIS1", size, "width of single row in bytes"), cfact.createIntegerCard("NAXIS2", 1L, "single-row table"), cfact.createIntegerCard("PCOUNT", 0L, "size of special data area"), cfact.createIntegerCard("GCOUNT", 1L, "one data group"), cfact.createIntegerCard("TFIELDS", nStdCol, "number of columns")));
        if (this.tname_ != null && this.tname_.trim().length() > 0) {
            cards.add(cfact.createStringCard("EXTNAME", this.tname_, "table name"));
        }
        if (hasExtCol) {
            cards.addAll(Arrays.asList(wide.getExtensionCards(nUseCol)));
            AbstractWideFits.logWideWrite(logger_, nStdCol, nUseCol);
        }
        int jcol = 0;
        for (int icol = 0; icol < this.ncol_; ++icol) {
            ColumnStore colStore = this.colStores_[icol];
            if (colStore == null) continue;
            if (hasExtCol && ++jcol == nStdCol) {
                cards.addAll(Arrays.asList(wide.getContainerColumnCards(extSize, this.nrow_)));
            }
            BintableColumnHeader colhead = hasExtCol && jcol >= nStdCol ? wide.createExtendedHeader(nStdCol, jcol) : BintableColumnHeader.createStandardHeader(jcol);
            cards.addAll(colStore.getHeaderInfo(colhead, jcol));
        }
        return cards.toArray(new CardImage[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeData(DataOutput out) throws IOException {
        long size = 0L;
        try {
            for (int icol = 0; icol < this.ncol_; ++icol) {
                if (this.colStores_[icol] == null) continue;
                logger_.info("Writing column " + (icol + 1) + "/" + this.ncol_ + ": " + this.colids_[icol]);
                ColumnStore colStore = this.colStores_[icol];
                colStore.streamData(out);
                size += colStore.getDataLength();
                colStore.dispose();
            }
        }
        finally {
            for (ColumnStore colStore : this.colStores_) {
                colStore.dispose();
            }
        }
        int over = (int)(size % 2880L);
        if (over > 0) {
            out.write(new byte[2880 - over]);
        }
    }

    @Override
    public long getRowCount() {
        return this.nrow_;
    }

    @Override
    public char getFormatChar(int icol) {
        ColumnStore colStore = this.colStores_[icol];
        if (colStore != null) {
            String tform = ColFitsTableSerializer.getCardValue(colStore, "TFORM").trim();
            return tform.charAt(tform.length() - 1);
        }
        return '\u0000';
    }

    @Override
    public int[] getDimensions(int icol) {
        ColumnStore colStore = this.colStores_[icol];
        if (colStore != null) {
            long[] tdims = ColFitsStarTable.parseTdim(ColFitsTableSerializer.getCardValue(colStore, "TDIM"));
            int[] dims = new int[tdims.length - 1];
            for (int i = 0; i < tdims.length - 1; ++i) {
                dims[i] = Tables.checkedLongToInt(tdims[i]);
            }
            return dims;
        }
        return null;
    }

    @Override
    public String getBadValue(int icol) {
        String tnull;
        ColumnStore colStore = this.colStores_[icol];
        if (colStore != null && (tnull = ColFitsTableSerializer.getCardValue(colStore, "TNULL")) != null && tnull.trim().length() > 0) {
            return tnull;
        }
        return null;
    }

    private static String getCardValue(ColumnStore colStore, String tcard) {
        int icol = 99;
        BintableColumnHeader colhead = BintableColumnHeader.createStandardHeader(icol);
        String key = colhead.getKeyName(tcard);
        for (CardImage card : colStore.getHeaderInfo(colhead, icol)) {
            ParsedCard<?> pcard = FitsUtil.parseCard(card.getBytes());
            if (pcard == null || !key.equals(pcard.getKey())) continue;
            return String.valueOf(pcard.getValue());
        }
        return null;
    }
}

