/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.awt.datatransfer.DataFlavor;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import uk.ac.starlink.fits.AsciiTableStarTable;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.QueueTableSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.DocumentedTableBuilder;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.util.URLUtils;

public class FitsTableBuilder
extends DocumentedTableBuilder
implements MultiTableBuilder {
    private static final Logger logger = Logger.getLogger("uk.ac.starlink.fits");
    private final WideFits wide_;

    public FitsTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public FitsTableBuilder(WideFits wide) {
        super(new String[]{"fit", "fits"});
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "FITS";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws IOException {
        if (!FitsUtil.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        in = datsrc.getInputStream();
        var5_5 = null;
        try {
            pos = new long[]{0L};
            spos = datsrc.getPosition();
            if (spos != null && spos.trim().length() > 0) {
                try {
                    ihdu = Integer.parseInt(spos.trim());
                }
                catch (NumberFormatException e) {
                    ihdu = -1;
                }
                if (ihdu >= 0) {
                    try {
                        pos[0] = pos[0] + FitsUtil.skipHDUs(in, ihdu);
                        table = FitsTableBuilder.attemptReadTable(in, wantRandom, datsrc, this.wide_, pos, policy);
                    }
                    catch (EOFException e) {
                        throw new IOException("Fell off end of file looking for HDU #" + ihdu, e);
                    }
                }
                try {
                    table = FitsTableBuilder.findNamedTable(in, datsrc, spos, this.wide_, pos, policy);
                }
                catch (EOFException e) {
                    throw new IOException("No extension found with EXTNAME or EXTNAME-EXTVER \"" + spos + "\"", e);
                }
                if (table != null) {
                    if (table.getName() == null) {
                        table.setName(datsrc.getName());
                    }
                    table.setURL(datsrc.getURL());
                    var10_17 = table;
                    return var10_17;
                }
                throw new IOException(datsrc + " not a Table HDU");
            }
            while (true) {
                table = FitsTableBuilder.attemptReadTable(in, wantRandom, datsrc, this.wide_, pos, policy);
                if (table == null) ** break block32
                if (table.getName() == null) {
                    table.setName(datsrc.getName());
                }
                table.setURL(datsrc.getURL());
                var9_14 = table;
                return var9_14;
                break;
            }
            {
                catch (EOFException e) {
                    throw new IOException("No table HDUs in " + datsrc, e);
                }
            }
            {
                continue;
            }
            catch (Throwable var6_7) {
                var5_5 = var6_7;
                throw var6_7;
            }
        }
        finally {
            if (in != null) {
                if (var5_5 != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable var11_19) {
                        var5_5.addSuppressed(var11_19);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy policy) throws IOException {
        String frag = datsrc.getPosition();
        if (frag != null && frag.trim().length() > 0) {
            return Tables.singleTableSequence(this.makeStarTable(datsrc, false, policy));
        }
        if (!FitsUtil.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS file");
        }
        MultiLoadWorker loadWorker = new MultiLoadWorker(datsrc, this.wide_, policy);
        loadWorker.start();
        return loadWorker.getTableSequence();
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("fits");
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String extnum) throws IOException {
        if (extnum != null && extnum.matches("[1-9][0-9]*")) {
            int ihdu = Integer.parseInt(extnum);
            FitsUtil.skipHDUs(in, ihdu);
            if (!this.attemptStreamStarTable(in, sink, false)) {
                throw new IOException("No table HDU at extension " + ihdu);
            }
        } else {
            boolean done = false;
            while (!done) {
                done = this.attemptStreamStarTable(in, sink, true);
            }
            if (!done) {
                throw new IOException("No table extensions found");
            }
        }
    }

    @Override
    public boolean canStream() {
        return true;
    }

    @Override
    public boolean docIncludesExample() {
        return false;
    }

    @Override
    public String getXmlDescription() {
        return this.readText("FitsTableBuilder.xml");
    }

    private boolean attemptStreamStarTable(InputStream in, TableSink sink, boolean readAnyway) throws IOException {
        FitsHeader hdr = FitsUtil.readHeader(in);
        String xtension = hdr.getStringValue("XTENSION");
        if ("BINTABLE".equals(xtension)) {
            BasicInput input = InputFactory.createSequentialInput(in);
            BintableStarTable.streamStarTable(hdr, input, this.wide_, sink);
            return true;
        }
        if ("TABLE".equals(xtension)) {
            BasicInput input = InputFactory.createSequentialInput(in);
            AsciiTableStarTable.streamStarTable(hdr, input, sink);
            return true;
        }
        if (readAnyway) {
            long datasize = hdr.getDataByteCount();
            IOUtils.skip((InputStream)in, (long)datasize);
        }
        return false;
    }

    public static StarTable findNamedTable(InputStream in, DataSource datsrc, String name, WideFits wide, long[] pos, StoragePolicy policy) throws IOException {
        while (true) {
            FitsHeader hdr = FitsUtil.readHeader(in);
            long headsize = hdr.getHeaderByteCount();
            long datasize = hdr.getDataByteCount();
            long datpos = pos[0] + headsize;
            pos[0] = pos[0] + (headsize + datasize);
            if (FitsTableBuilder.headerName(hdr, name)) {
                TableResult tres = FitsTableBuilder.attemptReadTableData(in, datsrc, datpos, hdr, wide, policy);
                assert (pos[0] == tres.afterPos_);
                return tres.table_;
            }
            IOUtils.skip((InputStream)in, (long)datasize);
        }
    }

    public static StarTable attemptReadTable(InputStream in, boolean wantRandom, DataSource datsrc, WideFits wide, long[] pos, StoragePolicy policy) throws IOException {
        FitsHeader hdr = FitsUtil.readHeader(in);
        long datpos = pos[0] + hdr.getHeaderByteCount();
        TableResult tres = FitsTableBuilder.attemptReadTableData(in, datsrc, datpos, hdr, wide, policy);
        pos[0] = tres.afterPos_;
        return tres.table_;
    }

    private static TableResult attemptReadTableData(InputStream in, DataSource datsrc, long datpos, FitsHeader hdr, WideFits wide, StoragePolicy policy) throws IOException {
        long datasize = hdr.getDataByteCount();
        long afterpos = datpos + datasize;
        String xtension = hdr.getStringValue("XTENSION");
        if ("BINTABLE".equals(xtension)) {
            InputFactory inFact;
            Long pcount = hdr.getLongValue("PCOUNT");
            if (pcount != null && pcount > 0L) {
                logger.info("FITS file has non-zero heap");
                inFact = InputFactory.createRandomFactory(datsrc, datpos, datasize, policy);
            } else {
                inFact = InputFactory.createFactory(datsrc, datpos, datasize);
            }
            BintableStarTable table = BintableStarTable.createTable(hdr, inFact, wide);
            try {
                IOUtils.skip((InputStream)in, (long)datasize);
            }
            catch (EOFException e) {
                throw new EOFException("FITS file too short for HDU - corrupted/truncated?");
            }
            return new TableResult(table, afterpos);
        }
        if ("TABLE".equals(xtension)) {
            InputFactory inFact = InputFactory.createFactory(datsrc, datpos, datasize);
            AsciiTableStarTable table = AsciiTableStarTable.createTable(hdr, inFact);
            IOUtils.skip((InputStream)in, (long)datasize);
            return new TableResult(table, afterpos);
        }
        IOUtils.skip((InputStream)in, (long)datasize);
        return new TableResult(null, afterpos);
    }

    private static boolean headerName(FitsHeader hdr, String name) {
        String extname = hdr.getStringValue("EXTNAME");
        if (extname == null || extname.trim().length() == 0) {
            return false;
        }
        if (extname.trim().equalsIgnoreCase(name)) {
            return true;
        }
        Integer extver = hdr.getIntValue("EXTVER");
        if (extver != null) {
            return (extname + "-" + extver).equalsIgnoreCase(name);
        }
        return false;
    }

    private static class TableResult {
        final StarTable table_;
        final long afterPos_;

        TableResult(StarTable table, long afterPos) {
            this.table_ = table;
            this.afterPos_ = afterPos;
        }
    }

    private static class MultiLoadWorker
    extends Thread {
        private final DataSource datsrc_;
        private final WideFits wide_;
        private final StoragePolicy policy_;
        private final QueueTableSequence tqueue_;

        MultiLoadWorker(DataSource datsrc, WideFits wide, StoragePolicy policy) {
            super("FITS multi table loader");
            this.setDaemon(true);
            this.datsrc_ = datsrc;
            this.wide_ = wide;
            this.policy_ = policy;
            this.tqueue_ = new QueueTableSequence();
        }

        TableSequence getTableSequence() {
            return this.tqueue_;
        }

        @Override
        public void run() {
            try {
                this.multiLoad();
            }
            catch (Throwable e) {
                this.tqueue_.addError(e);
            }
            finally {
                this.tqueue_.endSequence();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void multiLoad() throws IOException {
            try (InputStream in = this.datsrc_.getInputStream();){
                long pos = 0L;
                int ihdu = 0;
                while (true) {
                    FitsHeader hdr;
                    if ((hdr = FitsUtil.readHeaderIfPresent(in)) == null) {
                        if (ihdu == 0) {
                            throw new EOFException("Empty stream");
                        }
                        return;
                    }
                    long datpos = pos + hdr.getHeaderByteCount();
                    TableResult tres = FitsTableBuilder.attemptReadTableData(in, this.datsrc_, datpos, hdr, this.wide_, this.policy_);
                    StarTable table = tres.table_;
                    pos = tres.afterPos_;
                    if (table != null) {
                        URL baseUrl;
                        if (table.getName() == null) {
                            table.setName(this.datsrc_.getName() + "#" + ihdu);
                        }
                        if ((baseUrl = this.datsrc_.getURL()) != null && baseUrl.toString().indexOf(35) < 0) {
                            String hduUrl = baseUrl + "#" + ihdu;
                            try {
                                table.setURL(URLUtils.newURL((String)hduUrl));
                            }
                            catch (MalformedURLException e) {
                                logger.info("Bad URL " + hduUrl + "?");
                            }
                        }
                        this.tqueue_.addTable(table);
                    }
                    ++ihdu;
                    continue;
                    break;
                }
            }
        }
    }
}

