/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.io.IOException;
import java.util.List;
import uk.ac.starlink.fits.AbstractFitsTableWriter;
import uk.ac.starlink.fits.FitsTableSerializer;
import uk.ac.starlink.fits.StandardFitsTableSerializer;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnPermutedStarTable;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.MetaCopyStarTable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;

public class HealpixFitsTableWriter
extends AbstractFitsTableWriter {
    public HealpixFitsTableWriter() {
        super("fits-healpix");
        this.setAllowSignedByte(false);
        this.setWide(null);
    }

    @Override
    public boolean looksLikeFile(String location) {
        return false;
    }

    @Override
    protected FitsTableSerializer createSerializer(StarTable table) throws TableFormatException, IOException {
        List<DescribedValue> tparams = table.getParameters();
        if (!HealpixTableInfo.isHealpix(tparams)) {
            throw new TableFormatException("Table is not annotated as HEALPix");
        }
        HealpixTableInfo hpxInfo = HealpixTableInfo.fromParams(tparams);
        String ipixColName = hpxInfo.getPixelColumnName();
        if (ipixColName != null) {
            int icIpix = HealpixFitsTableWriter.getColumnIndex(table, ipixColName);
            if (icIpix < 0) {
                throw new TableFormatException("No column \"" + ipixColName + "\" in table");
            }
            if (icIpix > 0) {
                int ncol = table.getColumnCount();
                int[] colmap = new int[ncol];
                int jc = 0;
                colmap[jc++] = icIpix;
                for (int ic = 0; ic < ncol; ++ic) {
                    if (ic == icIpix) continue;
                    colmap[jc++] = ic;
                }
                assert (jc == ncol);
                table = new ColumnPermutedStarTable(table, colmap, true);
            }
            if (!"PIXEL".equals(table.getColumnInfo(0).getName())) {
                table = new MetaCopyStarTable(table);
                ColumnInfo info0 = table.getColumnInfo(0);
                info0.setName("PIXEL");
                info0.setDescription("HEALPix pixel index");
                table.setParameter(new DescribedValue(HealpixTableInfo.HPX_COLNAME_INFO, info0.getName()));
                hpxInfo = HealpixTableInfo.fromParams(table.getParameters());
            }
            boolean isExplicit = true;
        } else {
            boolean isExplicit = false;
        }
        StandardFitsTableSerializer fitser = new StandardFitsTableSerializer(this.getConfig(), table);
        fitser.getHealpixHeaders(hpxInfo);
        return fitser;
    }

    private static final int getColumnIndex(StarTable table, String cname) {
        int ncol = table.getColumnCount();
        for (int ic = 0; ic < ncol; ++ic) {
            if (!cname.equals(table.getColumnInfo(ic).getName())) continue;
            return ic;
        }
        return -1;
    }
}

