/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.fits;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.util.Loader;

public abstract class Unmapper {
    private static Unmapper instance_;
    private static final Logger logger_;
    public static final String UNMAP_PROPERTY = "startable.unmap";

    public abstract boolean unmap(MappedByteBuffer var1);

    public static synchronized Unmapper getInstance() {
        if (instance_ == null) {
            instance_ = Unmapper.createInstance();
        }
        return instance_;
    }

    private static Unmapper createInstance() {
        Option opt;
        String pref;
        try {
            pref = System.getProperty(UNMAP_PROPERTY);
        }
        catch (SecurityException e) {
            pref = null;
        }
        if (pref == null) {
            logger_.info("Buffer unmapping: attempt to use sun.misc implementation");
            opt = Option.SUN;
        } else {
            opt = Option.getOption(pref);
            if (opt != null) {
                logger_.info("Buffer unmapping: attempt to use " + (Object)((Object)opt) + " by explicit request");
            }
        }
        if (opt != null) {
            try {
                Unmapper unmapper = opt.createUnmapper();
                logger_.config("Buffer unmapping: using " + unmapper + "; unmapping should work");
                return unmapper;
            }
            catch (Throwable e) {
                logger_.log(Level.WARNING, "Buffer unmapping failed, fall back to no-op", e);
                return new NopUnmapper();
            }
        }
        if ("none".equalsIgnoreCase(pref)) {
            logger_.info("Buffer unmapping: using no-op unmapper by explicit request");
            logger_.config("Buffer unmapping: no explicit unmapping");
            return new NopUnmapper();
        }
        Unmapper unmapper = (Unmapper)Loader.getClassInstance((String)pref, Unmapper.class);
        if (unmapper != null) {
            logger_.info("Using custom buffer unmapper " + pref + " by explicit request");
            return unmapper;
        }
        logger_.log(Level.WARNING, "Can't use unknown unmapper " + pref + ", fall back to no-op");
        return new NopUnmapper();
    }

    private static Unmapper createSunUnmapper() throws Exception {
        boolean hasCleaner;
        try {
            Class.forName("sun.misc.Cleaner");
            hasCleaner = true;
        }
        catch (ClassNotFoundException e) {
            hasCleaner = false;
        }
        return hasCleaner ? new CleanerUnmapper() : new UnsafeUnmapper();
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.fits");
    }

    private static enum Option {
        CLEANER{

            @Override
            Unmapper createUnmapper() throws Exception {
                return new CleanerUnmapper();
            }
        }
        ,
        UNSAFE{

            @Override
            Unmapper createUnmapper() throws Exception {
                return new UnsafeUnmapper();
            }
        }
        ,
        SUN{

            @Override
            Unmapper createUnmapper() throws Exception {
                return Unmapper.createSunUnmapper();
            }
        };


        abstract Unmapper createUnmapper() throws Exception;

        static Option getOption(String name) {
            for (Option opt : Option.values()) {
                if (!opt.toString().equalsIgnoreCase(name)) continue;
                return opt;
            }
            return null;
        }
    }

    private static class NopUnmapper
    extends Unmapper {
        private NopUnmapper() {
        }

        @Override
        public boolean unmap(MappedByteBuffer buf) {
            return false;
        }

        public String toString() {
            return "Nop";
        }
    }

    private static class UnsafeUnmapper
    extends Unmapper {
        private final Object unsafe_;
        private final Method invokeCleanerMethod_;

        UnsafeUnmapper() throws Exception {
            Class<?> unsafeClazz = Class.forName("sun.misc.Unsafe");
            Field theUnsafe = unsafeClazz.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            this.unsafe_ = theUnsafe.get(null);
            this.invokeCleanerMethod_ = unsafeClazz.getDeclaredMethod("invokeCleaner", ByteBuffer.class);
        }

        @Override
        public boolean unmap(MappedByteBuffer buf) {
            try {
                this.invokeCleanerMethod_.invoke(this.unsafe_, buf);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }

        public String toString() {
            return "Unsafe";
        }
    }

    private static class CleanerUnmapper
    extends Unmapper {
        private final Class<?> directBufferClazz_ = Class.forName("sun.nio.ch.DirectBuffer");
        private final Class<?> cleanerClazz_ = Class.forName("sun.misc.Cleaner");
        private final Method cleanerMethod_ = this.directBufferClazz_.getMethod("cleaner", new Class[0]);
        private final Method cleanMethod_ = this.cleanerClazz_.getMethod("clean", new Class[0]);

        CleanerUnmapper() throws Exception {
        }

        @Override
        public boolean unmap(MappedByteBuffer buf) {
            if (this.directBufferClazz_.isAssignableFrom(buf.getClass())) {
                try {
                    this.cleanMethod_.invoke(this.cleanerMethod_.invoke((Object)buf, new Object[0]), new Object[0]);
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }

        public String toString() {
            return "Cleaner";
        }
    }
}

