/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.fits.ColFitsStarTable;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.FitsPlusTableBuilder;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class ColFitsPlusTableBuilder
implements TableBuilder {
    private final WideFits wide_;

    public ColFitsPlusTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public ColFitsPlusTableBuilder(WideFits wide) {
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "colfits-plus";
    }

    @Override
    public boolean looksLikeFile(String location) {
        return location.toLowerCase().endsWith(".colfits");
    }

    @Override
    public void streamStarTable(InputStream in, TableSink sink, String pos) throws TableFormatException {
        throw new TableFormatException("Can't stream from " + this.getFormatName() + " format");
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy policy) throws IOException {
        long dataPos;
        FitsHeader hdr;
        TableElement tableMeta;
        if (datsrc.getPosition() != null) {
            throw new TableFormatException("Can't locate numbered HDU");
        }
        if (!ColFitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a " + this.getFormatName() + " file");
        }
        try (InputStream in = datsrc.getInputStream();){
            long[] pos = new long[1];
            tableMeta = this.readMetadata(in, pos);
            hdr = FitsUtil.readHeader(in);
            pos[0] = pos[0] + hdr.getHeaderByteCount();
            dataPos = pos[0];
        }
        ColFitsStarTable tableData = new ColFitsStarTable(datsrc, hdr, dataPos, false, this.wide_);
        if (tableMeta != null) {
            tableMeta.setData(new TableBodies.StarTableTabularData(tableData));
            return new VOStarTable(tableMeta);
        }
        return tableData;
    }

    public static boolean isMagic(byte[] buffer) {
        int ntest = 6;
        if (buffer.length < 480) {
            return false;
        }
        byte[] cbuf = new byte[80];
        for (int il = 0; il < 6; ++il) {
            System.arraycopy(buffer, il * 80, cbuf, 0, 80);
            ParsedCard<?> card = FitsUtil.parseCard(cbuf);
            if (ColFitsPlusTableBuilder.primaryHeaderCardOK(il, card)) continue;
            return false;
        }
        return true;
    }

    private static boolean primaryHeaderCardOK(int icard, ParsedCard<?> card) {
        String key = card.getKey();
        Object value = card.getValue();
        switch (icard) {
            case 4: {
                return "COLFITS".equals(key) && Boolean.TRUE.equals(value);
            }
            case 5: {
                return "VOTMETA".equals(key);
            }
        }
        return FitsPlusTableBuilder.primaryHeaderCardOK(icard, card);
    }

    private TableElement readMetadata(InputStream in, long[] pos) throws IOException {
        DOMSource domsrc;
        FitsHeader hdr = FitsUtil.readHeader(in);
        long headsize = hdr.getHeaderByteCount();
        long datasize = hdr.getDataByteCount();
        pos[0] = headsize + datasize;
        int nbyte = hdr.getRequiredIntValue("NAXIS1");
        byte[] vobuf = IOUtils.readBytes(in, nbyte);
        if (vobuf.length < nbyte) {
            throw new TableFormatException("Primary HDU truncated");
        }
        int pad = (int)(datasize - (long)nbyte);
        IOUtils.skip(in, pad);
        if (!Boolean.TRUE.equals(hdr.getBooleanValue("VOTMETA"))) {
            return null;
        }
        VOElementFactory vofact = new VOElementFactory();
        try {
            domsrc = vofact.transformToDOM(new StreamSource(new ByteArrayInputStream(vobuf)), false);
        }
        catch (SAXException e) {
            throw new TableFormatException("VOTable parse failed", e);
        }
        VODocument doc = (VODocument)domsrc.getNode();
        VOElement topel = (VOElement)doc.getDocumentElement();
        NodeList tabelList = topel.getElementsByVOTagName("TABLE");
        int ntabel = tabelList.getLength();
        if (ntabel == 0) {
            throw new TableFormatException("Embedded VOTable document has no TABLE element");
        }
        if (ntabel > 1) {
            throw new TableFormatException("Embedded VOTable document has multiple(" + ntabel + ") TABLE elements");
        }
        TableElement tabel = (TableElement)tabelList.item(0);
        if (tabel.getChildByName("DATA") != null) {
            throw new TableFormatException("Embedded VOTable document has unexpected DATA element");
        }
        return tabel;
    }
}

