/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.awt.datatransfer.DataFlavor;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import uk.ac.starlink.fits.BasicInput;
import uk.ac.starlink.fits.BintableStarTable;
import uk.ac.starlink.fits.FitsHeader;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.fits.FitsUtil;
import uk.ac.starlink.fits.InputFactory;
import uk.ac.starlink.fits.ParsedCard;
import uk.ac.starlink.fits.WideFits;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.MultiTableBuilder;
import uk.ac.starlink.table.QueueTableSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSequence;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.IOUtils;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VODocument;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.VOStarTable;

public class FitsPlusTableBuilder
implements TableBuilder,
MultiTableBuilder {
    private final WideFits wide_;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.votable");

    public FitsPlusTableBuilder() {
        this(WideFits.DEFAULT);
    }

    public FitsPlusTableBuilder(WideFits wide) {
        this.wide_ = wide;
    }

    @Override
    public String getFormatName() {
        return "FITS-plus";
    }

    @Override
    public boolean looksLikeFile(String location) {
        String loc = location.toLowerCase();
        return loc.endsWith(".fit") || loc.endsWith(".fits");
    }

    @Override
    public StarTable makeStarTable(DataSource datsrc, boolean wantRandom, StoragePolicy storagePolicy) throws IOException {
        if (!FitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS-plus file");
        }
        InputStream in = datsrc.getInputStream();
        long[] pos = new long[1];
        TableElement[] tabels = FitsPlusTableBuilder.readMetadata(in, pos);
        int iTable = FitsPlusTableBuilder.getTableIndex(datsrc.getPosition(), tabels.length);
        TableElement tabel = tabels[iTable];
        pos[0] = pos[0] + FitsUtil.skipHDUs(in, iTable);
        StarTable starTable = FitsTableBuilder.attemptReadTable(in, wantRandom, datsrc, this.wide_, pos, storagePolicy);
        if (starTable == null) {
            throw new TableFormatException("No BINTABLE HDU found");
        }
        return FitsPlusTableBuilder.createFitsPlusTable(tabel, starTable);
    }

    @Override
    public TableSequence makeStarTables(DataSource datsrc, StoragePolicy storagePolicy) throws IOException {
        String srcpos = datsrc.getPosition();
        if (srcpos != null && srcpos.trim().length() > 0) {
            return Tables.singleTableSequence(this.makeStarTable(datsrc, false, storagePolicy));
        }
        if (!FitsPlusTableBuilder.isMagic(datsrc.getIntro())) {
            throw new TableFormatException("Doesn't look like a FITS-plus file");
        }
        MultiLoadWorker loadWorker = new MultiLoadWorker(datsrc, this.wide_);
        loadWorker.start();
        return loadWorker.getTableSequence();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void streamStarTable(InputStream in, final TableSink sink, String pos) throws IOException {
        try {
            TableElement[] tabels = FitsPlusTableBuilder.readMetadata(in, new long[1]);
            int iTable = FitsPlusTableBuilder.getTableIndex(pos, tabels.length);
            TableElement tabel = tabels[iTable];
            FitsUtil.skipHDUs(in, iTable);
            final VOStarTable voMeta = new VOStarTable(tabel);
            TableSink wsink = new TableSink(){

                @Override
                public void acceptMetadata(StarTable fitsMeta) throws TableFormatException {
                    sink.acceptMetadata(voMeta);
                }

                @Override
                public void acceptRow(Object[] row) throws IOException {
                    sink.acceptRow(row);
                }

                @Override
                public void endRows() throws IOException {
                    sink.endRows();
                }
            };
            FitsHeader hdr = FitsUtil.readHeader(in);
            BasicInput input = InputFactory.createSequentialInput(in);
            BintableStarTable.streamStarTable(hdr, input, this.wide_, wsink);
        }
        finally {
            in.close();
        }
    }

    private static TableElement[] readMetadata(InputStream in, long[] pos) throws IOException {
        DOMSource domsrc;
        byte[] headBuf = IOUtils.readBytes(in, 2880);
        if (headBuf.length < 2880 || !FitsPlusTableBuilder.isMagic(headBuf)) {
            throw new TableFormatException("Primary header not FITS-plus");
        }
        FitsHeader hdr = FitsUtil.readHeader(new ByteArrayInputStream(headBuf));
        long headsize = hdr.getHeaderByteCount();
        long datasize = hdr.getDataByteCount();
        pos[0] = headsize + datasize;
        assert (headsize == 2880L);
        assert (hdr.getRequiredIntValue("NAXIS") == 1);
        assert (hdr.getRequiredIntValue("BITPIX") == 8);
        int nbyte = hdr.getRequiredIntValue("NAXIS1");
        byte[] vobuf = IOUtils.readBytes(in, nbyte);
        if (vobuf.length < nbyte) {
            throw new TableFormatException("Primary HDU truncated");
        }
        int pad = (int)(datasize - (long)nbyte);
        IOUtils.skip(in, pad);
        VOElementFactory vofact = new VOElementFactory();
        try {
            domsrc = vofact.transformToDOM(new StreamSource(new BufferedInputStream(new ByteArrayInputStream(vobuf))), false);
        }
        catch (SAXException e) {
            throw new TableFormatException("VOTable parse failed", e);
        }
        VODocument doc = (VODocument)domsrc.getNode();
        VOElement topel = (VOElement)doc.getDocumentElement();
        NodeList tlist = topel.getElementsByVOTagName("TABLE");
        int nTable = tlist.getLength();
        TableElement[] tabels = new TableElement[nTable];
        for (int i = 0; i < nTable; ++i) {
            tabels[i] = (TableElement)tlist.item(i);
            if (tabels[i].getChildByName("DATA") == null) continue;
            throw new TableFormatException("TABLE #" + (i + i) + " in embedded VOTable document has unexpected DATA element");
        }
        return tabels;
    }

    private static int getTableIndex(String pos, int nTable) throws TableFormatException {
        if (nTable <= 0) {
            throw new TableFormatException("No tables present in FITS-plus container");
        }
        if (pos == null || pos.trim().length() == 0) {
            return 0;
        }
        try {
            int index = Integer.parseInt(pos.trim());
            if (index >= 1 && index <= nTable) {
                return index - 1;
            }
            if (index == 0) {
                throw new TableFormatException("No table with position " + pos + "; first table is #1");
            }
            throw new TableFormatException("No table with position " + pos + "; there are " + nTable);
        }
        catch (NumberFormatException e) {
            throw new TableFormatException("Can't interpret position " + pos + " (not a number)", e);
        }
    }

    private static StarTable createFitsPlusTable(TableElement tabEl, StarTable dataTable) throws IOException {
        FieldElement[] fields = tabEl.getFields();
        if (fields.length != dataTable.getColumnCount()) {
            throw new TableFormatException("FITS/VOTable metadata mismatch - column counts differ");
        }
        for (int ic = 0; ic < fields.length; ++ic) {
            Class<?> vclazz;
            Class<?> fclazz = dataTable.getColumnInfo(ic).getContentClass();
            if (fclazz.equals(vclazz = fields[ic].getDecoder().getContentClass()) || (fclazz.equals(String.class) || fclazz.equals(Character.class) || fclazz.equals(char[].class)) && (vclazz.equals(String.class) || vclazz.equals(Character.class) || vclazz.equals(char[].class))) continue;
            throw new TableFormatException("FITS/VOTable metadata mismatch - column types differ");
        }
        VOStarTable outTable = VOStarTable.createDecoratedTable(dataTable, tabEl);
        int ncol = dataTable.getColumnCount();
        assert (ncol == outTable.getColumnCount());
        for (int icol = 0; icol < ncol; ++icol) {
            ColumnInfo fInfo = dataTable.getColumnInfo(icol);
            ColumnInfo vInfo = outTable.getColumnInfo(icol);
            if (vInfo.getContentClass().isAssignableFrom(fInfo.getContentClass())) continue;
            vInfo.setContentClass(fInfo.getContentClass());
        }
        return outTable;
    }

    @Override
    public boolean canImport(DataFlavor flavor) {
        return flavor.getPrimaryType().equals("application") && flavor.getSubType().equals("fits");
    }

    public static boolean isMagic(byte[] buffer) {
        int ntest = 5;
        if (buffer.length < 400) {
            return false;
        }
        byte[] cbuf = new byte[80];
        for (int il = 0; il < 5; ++il) {
            System.arraycopy(buffer, il * 80, cbuf, 0, 80);
            ParsedCard<?> card = FitsUtil.parseCard(cbuf);
            if (FitsPlusTableBuilder.primaryHeaderCardOK(il, card)) continue;
            return false;
        }
        return true;
    }

    static boolean primaryHeaderCardOK(int icard, ParsedCard<?> card) {
        String key = card.getKey();
        Object value = card.getValue();
        switch (icard) {
            case 0: {
                return "SIMPLE".equals(key) && Boolean.TRUE.equals(value);
            }
            case 1: {
                return "BITPIX".equals(key) && value instanceof Number && ((Number)value).intValue() == 8;
            }
            case 2: {
                return "NAXIS".equals(key) && value instanceof Number && ((Number)value).intValue() == 1;
            }
            case 3: {
                return "NAXIS1".equals(key) && value instanceof Number;
            }
            case 4: {
                return "VOTMETA".equals(key) && Boolean.TRUE.equals(value);
            }
        }
        return true;
    }

    private static class MultiLoadWorker
    extends Thread {
        private final DataSource datsrc_;
        private final WideFits wide_;
        private final QueueTableSequence tqueue_;

        MultiLoadWorker(DataSource datsrc, WideFits wide) {
            super("FITS-plus multi table loader");
            this.setDaemon(true);
            this.datsrc_ = datsrc;
            this.wide_ = wide;
            this.tqueue_ = new QueueTableSequence();
        }

        TableSequence getTableSequence() {
            return this.tqueue_;
        }

        @Override
        public void run() {
            try {
                this.multiLoad();
            }
            catch (Throwable e) {
                this.tqueue_.addError(e);
            }
            finally {
                this.tqueue_.endSequence();
            }
        }

        private void multiLoad() throws IOException {
            try (InputStream in = this.datsrc_.getInputStream();){
                long[] posptr = new long[1];
                TableElement[] tabEls = FitsPlusTableBuilder.readMetadata(in, posptr);
                long pos = posptr[0];
                int nTable = tabEls.length;
                for (int itab = 0; itab < nTable; ++itab) {
                    FitsHeader hdr = FitsUtil.readHeader(in);
                    long headsize = hdr.getHeaderByteCount();
                    long datasize = hdr.getDataByteCount();
                    long datpos = pos + headsize;
                    if (!"BINTABLE".equals(hdr.getStringValue("XTENSION"))) {
                        throw new TableFormatException("Non-BINTABLE at ext #" + itab + " - not FITS-plus");
                    }
                    InputFactory inFact = InputFactory.createFactory(this.datsrc_, datpos, datasize);
                    BintableStarTable dataTable = BintableStarTable.createTable(hdr, inFact, this.wide_);
                    this.tqueue_.addTable(FitsPlusTableBuilder.createFitsPlusTable(tabEls[itab], dataTable));
                    try {
                        IOUtils.skip(in, datasize);
                    }
                    catch (EOFException e) {
                        throw new EOFException("FITS file too short for HDU - corrupted/truncated?");
                    }
                    pos += headsize + datasize;
                }
            }
        }
    }
}

