/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.IOException;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.votable.TableHandler;

class TableHandlerSink
implements TableSink {
    private final TableHandler handler_;
    private boolean metadataSent_;

    public TableHandlerSink(TableHandler handler, StarTable meta) throws SAXException {
        this.handler_ = handler;
        if (meta != null) {
            this.handler_.startTable(meta);
            this.metadataSent_ = true;
        }
    }

    @Override
    public void acceptMetadata(StarTable meta) throws TableFormatException {
        if (!this.metadataSent_) {
            this.metadataSent_ = true;
            try {
                this.handler_.startTable(meta);
            }
            catch (SAXException e) {
                throw new TableFormatException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void acceptRow(Object[] row) throws IOException {
        try {
            this.handler_.rowData(row);
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    @Override
    public void endRows() throws IOException {
        try {
            this.handler_.endTable();
        }
        catch (SAXException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

