/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.votable.VOStarTable;

public class Timesys {
    private final double timeorigin_;
    private final String timescale_;
    private final String refposition_;

    protected Timesys(double timeorigin, String timescale, String refposition) {
        this.timeorigin_ = timeorigin;
        this.timescale_ = timescale;
        this.refposition_ = refposition;
    }

    public double getTimeorigin() {
        return this.timeorigin_;
    }

    public String getTimescale() {
        return this.timescale_;
    }

    public String getRefposition() {
        return this.refposition_;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer().append("TIMESYS(").append("timescale=").append(this.timescale_).append(",").append(",refposition=").append(this.refposition_);
        if (!Double.isNaN(this.timeorigin_)) {
            sbuf.append(",timeorigin=");
            if (this.timeorigin_ == 0.0) {
                sbuf.append("JD-origin");
            } else if (this.timeorigin_ == 2400000.5) {
                sbuf.append("MJD-origin");
            } else {
                sbuf.append(this.timeorigin_);
            }
        }
        sbuf.append(")");
        return sbuf.toString();
    }

    public static double decodeTimeorigin(String txt) throws NumberFormatException {
        if (txt == null || txt.trim().length() == 0) {
            return Double.NaN;
        }
        String timeorigin = txt.trim();
        if ("JD-origin".equalsIgnoreCase(timeorigin)) {
            return 0.0;
        }
        if ("MJD-origin".equalsIgnoreCase(timeorigin)) {
            return 2400000.5;
        }
        return Double.parseDouble(timeorigin);
    }

    public static Timesys getTimesys(ValueInfo info) {
        String timeoriginTxt = Tables.getAuxDatumValue(info, VOStarTable.TIMESYS_TIMEORIGIN_INFO, String.class);
        String timescale = Tables.getAuxDatumValue(info, VOStarTable.TIMESYS_TIMESCALE_INFO, String.class);
        String refposition = Tables.getAuxDatumValue(info, VOStarTable.TIMESYS_REFPOSITION_INFO, String.class);
        if (timescale != null && timescale.trim().length() > 0 && refposition != null && refposition.trim().length() > 0) {
            double timeorigin;
            try {
                timeorigin = Timesys.decodeTimeorigin(timeoriginTxt);
            }
            catch (NumberFormatException e) {
                return null;
            }
            return new Timesys(timeorigin, timescale, refposition);
        }
        return null;
    }
}

