/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.FieldRefElement;
import uk.ac.starlink.votable.GroupElement;
import uk.ac.starlink.votable.LinkElement;
import uk.ac.starlink.votable.Namespacing;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.ParamRefElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.TimesysElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.ValuesElement;
import uk.ac.starlink.votable.dom.DelegatingAttr;
import uk.ac.starlink.votable.dom.DelegatingDocument;
import uk.ac.starlink.votable.dom.DelegatingElement;
import uk.ac.starlink.votable.dom.DelegatingNode;

public class VODocument
extends DelegatingDocument {
    private final String systemId_;
    private final Map<String, Element> idMap_ = new HashMap<String, Element>();
    private final Namespacing namespacing_;
    private final IntMap elCountMap_ = new IntMap();
    private StoragePolicy storagePolicy_ = StoragePolicy.PREFER_MEMORY;
    private boolean strict_;

    VODocument(Document base, String systemId, boolean strict) {
        super(base, systemId);
        this.systemId_ = systemId;
        this.strict_ = strict;
        this.namespacing_ = Namespacing.getInstance();
    }

    public VODocument(String systemId, boolean strict) {
        super(systemId);
        this.systemId_ = systemId;
        this.strict_ = strict;
        this.namespacing_ = Namespacing.getInstance();
    }

    public VODocument() {
        this((String)null, VOElementFactory.isStrictByDefault());
    }

    public String getSystemId() {
        return this.systemId_;
    }

    public StoragePolicy getStoragePolicy() {
        return this.storagePolicy_;
    }

    public void setStoragePolicy(StoragePolicy policy) {
        this.storagePolicy_ = policy;
    }

    public void setElementId(Element el, String id) {
        this.idMap_.put(id, el);
    }

    @Override
    public Element getElementById(String elementId) {
        return this.idMap_.get(elementId);
    }

    @Override
    public DelegatingNode getDelegator(Node base) {
        return super.getDelegator(base);
    }

    public int getElementCount(String voTagName) {
        return this.elCountMap_.getValue(voTagName);
    }

    @Override
    protected DelegatingElement createDelegatingElement(Element node) {
        String tagName = this.getVOTagName(node);
        this.elCountMap_.incValue(tagName);
        if ("FIELD".equals(tagName)) {
            return new FieldElement(node, this);
        }
        if ("LINK".equals(tagName)) {
            return new LinkElement(node, this);
        }
        if ("PARAM".equals(tagName)) {
            return new ParamElement(node, this);
        }
        if ("TABLE".equals(tagName)) {
            return new TableElement(node, this);
        }
        if ("VALUES".equals(tagName)) {
            return new ValuesElement(node, this);
        }
        if ("GROUP".equals(tagName)) {
            return new GroupElement(node, this);
        }
        if ("FIELDref".equals(tagName)) {
            return new FieldRefElement(node, this);
        }
        if ("PARAMref".equals(tagName)) {
            return new ParamRefElement(node, this);
        }
        if ("TIMESYS".equals(tagName)) {
            return new TimesysElement(node, this);
        }
        return new VOElement(node, this);
    }

    @Override
    protected DelegatingAttr createDelegatingAttr(Attr baseNode) {
        return "ID".equals(baseNode.getName()) ? super.createDelegatingAttr(baseNode, true) : super.createDelegatingAttr(baseNode);
    }

    boolean isStrict() {
        return this.strict_;
    }

    public String getVOTagName(Element el) {
        return this.namespacing_.getVOTagName(el);
    }

    private static class IntMap {
        private final Map<String, int[]> map_ = new HashMap<String, int[]>();

        private IntMap() {
        }

        int getValue(String key) {
            return this.map_.containsKey(key) ? this.map_.get(key)[0] : 0;
        }

        void putValue(String key, int ival) {
            if (!this.map_.containsKey(key)) {
                this.map_.put(key, new int[1]);
            }
            this.map_.get((Object)key)[0] = ival;
        }

        void incValue(String key) {
            if (!this.map_.containsKey(key)) {
                this.map_.put(key, new int[1]);
            }
            int[] nArray = this.map_.get(key);
            nArray[0] = nArray[0] + 1;
        }
    }
}

