/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.pds4;

import gov.nasa.pds.label.object.FieldType;
import gov.nasa.pds.objectAccess.table.FieldAdapter;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.function.DoubleFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.LongFunction;
import java.util.function.UnaryOperator;
import java.util.logging.Logger;
import uk.ac.starlink.pds4.SafeFieldAdapter;
import uk.ac.starlink.util.DoubleList;
import uk.ac.starlink.util.FloatList;
import uk.ac.starlink.util.IntList;
import uk.ac.starlink.util.LongList;
import uk.ac.starlink.util.ShortList;

public abstract class FieldReader<S, A> {
    private final FieldType ftype_;
    private final Class<S> scalarClazz_;
    private final Class<A> arrayClazz_;
    private static final boolean IS_SAFE = true;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.pds4");

    private FieldReader(FieldType ftype, Class<S> scalarClazz, Class<A> arrayClazz) {
        this.ftype_ = ftype;
        this.scalarClazz_ = scalarClazz;
        this.arrayClazz_ = arrayClazz;
    }

    public abstract S readScalar(byte[] var1, int var2, int var3, int var4, int var5);

    public abstract void readElement(byte[] var1, int var2, int var3, int var4, int var5, A var6, int var7);

    public abstract A createArray(int var1);

    public Class<S> getScalarClass() {
        return this.scalarClazz_;
    }

    public Class<A> getArrayClass() {
        return this.arrayClazz_;
    }

    public FieldType getFieldType() {
        return this.ftype_;
    }

    /*
     * WARNING - void declaration
     */
    public static FieldReader<?, ?> getInstance(FieldType ftype, String[] blankTxts) {
        FieldAdapter adapter0 = ftype.getAdapter();
        final SafeFieldAdapter adapter = new SafeFieldAdapter(adapter0);
        switch (ftype) {
            case UTF8_STRING: 
            case ASCII_ANYURI: 
            case ASCII_BIBCODE: 
            case ASCII_DATE: 
            case ASCII_DATE_DOY: 
            case ASCII_DATE_TIME: 
            case ASCII_DATE_TIME_DOY: 
            case ASCII_DATE_TIME_DOY_UTC: 
            case ASCII_DATE_TIME_UTC: 
            case ASCII_DATE_TIME_YMD: 
            case ASCII_DATE_TIME_YMD_UTC: 
            case ASCII_DATE_YMD: 
            case ASCII_DIRECTORY_PATH_NAME: 
            case ASCII_DOI: 
            case ASCII_FILE_NAME: 
            case ASCII_FILE_SPECIFICATION_NAME: 
            case ASCII_LID: 
            case ASCII_LIDVID: 
            case ASCII_LIDVID_LID: 
            case ASCII_MD5_CHECKSUM: 
            case ASCII_STRING: 
            case ASCII_TIME: 
            case ASCII_VID: 
            case COMPLEXLSB16: 
            case COMPLEXLSB8: 
            case COMPLEXMSB16: 
            case COMPLEXMSB8: 
            case SIGNEDBITSTRING: 
            case UNSIGNEDBITSTRING: 
            case UNKNOWN: {
                void var5_14;
                int nblank = blankTxts.length;
                if (nblank == 0) {
                    UnaryOperator unaryOperator = UnaryOperator.identity();
                } else if (nblank == 1) {
                    String blank = blankTxts[0];
                    UnaryOperator unaryOperator = s -> s.equals(blank) ? null : s;
                } else {
                    UnaryOperator unaryOperator = s -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (!s.equals(blankTxts[i])) continue;
                            return null;
                        }
                        return s;
                    };
                }
                return new FieldReader<String, String[]>(ftype, String.class, String[].class, (UnaryOperator)var5_14){
                    final /* synthetic */ UnaryOperator val$wrapString;
                    {
                        this.val$wrapString = unaryOperator;
                        super(ftype, scalarClazz, arrayClazz);
                    }

                    @Override
                    public String readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        String txt = adapter.getString(buf, off, leng, startBit, endBit);
                        return txt == null ? null : (String)this.val$wrapString.apply(txt.trim());
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, String[] array, int iel) {
                        String txt = adapter.getString(buf, off, leng, startBit, endBit);
                        array[iel] = txt == null ? null : (String)this.val$wrapString.apply(txt.trim());
                    }

                    @Override
                    public String[] createArray(int n) {
                        return new String[n];
                    }
                };
            }
            case ASCII_BOOLEAN: {
                return new FieldReader<Boolean, boolean[]>(ftype, Boolean.class, boolean[].class){

                    @Override
                    public Boolean readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        String txt = adapter.getString(buf, off, leng, startBit, endBit);
                        String string = txt = txt == null ? null : txt.trim();
                        if ("true".equals(txt) || "1".equals(txt)) {
                            return Boolean.TRUE;
                        }
                        if ("false".equals(txt) || "0".equals(txt)) {
                            return Boolean.FALSE;
                        }
                        return null;
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, boolean[] array, int iel) {
                        String txt = adapter.getString(buf, off, leng, startBit, endBit);
                        txt = txt == null ? null : txt.trim();
                        array[iel] = "true".equals(txt) || "1".equals(txt);
                    }

                    @Override
                    public boolean[] createArray(int n) {
                        return new boolean[n];
                    }
                };
            }
            case SIGNEDBYTE: 
            case UNSIGNEDBYTE: 
            case SIGNEDLSB2: 
            case SIGNEDMSB2: {
                ShortFunction<Short> wrapShort;
                ShortList blankList = new ShortList();
                for (String txt : blankTxts) {
                    try {
                        blankList.add(Short.parseShort(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                short[] sArray = blankList.toShortArray();
                int nblank = sArray.length;
                if (nblank == 0) {
                    wrapShort = Short::valueOf;
                } else if (nblank == 1) {
                    short blank = sArray[0];
                    wrapShort = s -> s == blank ? null : Short.valueOf(s);
                } else {
                    wrapShort = s -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (s != blanks[i]) continue;
                            return null;
                        }
                        return s;
                    };
                }
                return new FieldReader<Short, short[]>(ftype, Short.class, short[].class){

                    @Override
                    public Short readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        return (Short)wrapShort.apply(adapter.getShort(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, short[] array, int iel) {
                        array[iel] = adapter.getShort(buf, off, leng, startBit, endBit);
                    }

                    @Override
                    public short[] createArray(int n) {
                        return new short[n];
                    }
                };
            }
            case SIGNEDLSB4: 
            case SIGNEDMSB4: 
            case UNSIGNEDLSB2: 
            case UNSIGNEDMSB2: {
                IntFunction<Integer> wrapInt;
                IntList blankList = new IntList();
                for (String txt : blankTxts) {
                    try {
                        blankList.add(Integer.parseInt(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int[] nArray = blankList.toIntArray();
                int nblank = nArray.length;
                if (nblank == 0) {
                    wrapInt = Integer::valueOf;
                } else if (nblank == 1) {
                    int blank = nArray[0];
                    wrapInt = i -> i == blank ? null : Integer.valueOf(i);
                } else {
                    wrapInt = j -> {
                        for (int k = 0; k < nblank; ++k) {
                            if (j != nArray[k]) continue;
                            return null;
                        }
                        return j;
                    };
                }
                return new FieldReader<Integer, int[]>(ftype, Integer.class, int[].class){

                    @Override
                    public Integer readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        return (Integer)wrapInt.apply(adapter.getInt(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, int[] array, int iel) {
                        array[iel] = adapter.getInt(buf, off, leng, startBit, endBit);
                    }

                    @Override
                    public int[] createArray(int n) {
                        return new int[n];
                    }
                };
            }
            case SIGNEDLSB8: 
            case SIGNEDMSB8: 
            case UNSIGNEDLSB4: 
            case UNSIGNEDMSB4: 
            case ASCII_INTEGER: 
            case ASCII_NONNEGATIVE_INTEGER: 
            case ASCII_NUMERIC_BASE16: 
            case ASCII_NUMERIC_BASE2: 
            case ASCII_NUMERIC_BASE8: {
                LongFunction<Long> wrapLong;
                LongList blankList = new LongList();
                for (String txt : blankTxts) {
                    try {
                        blankList.add(Long.parseLong(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                long[] lArray = blankList.toLongArray();
                int nblank = lArray.length;
                if (nblank == 0) {
                    wrapLong = Long::valueOf;
                } else if (nblank == 1) {
                    long blank = lArray[0];
                    wrapLong = l -> l == blank ? null : Long.valueOf(l);
                } else {
                    wrapLong = l -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (l != lArray[i]) continue;
                            return null;
                        }
                        return l;
                    };
                }
                return new FieldReader<Long, long[]>(ftype, Long.class, long[].class){

                    @Override
                    public Long readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        return (Long)wrapLong.apply(adapter.getLong(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, long[] array, int iel) {
                        array[iel] = adapter.getLong(buf, off, leng, startBit, endBit);
                    }

                    @Override
                    public long[] createArray(int n) {
                        return new long[n];
                    }
                };
            }
            case IEEE754LSBSINGLE: 
            case IEEE754MSBSINGLE: {
                FloatUnaryOperator maskFloat;
                FloatFunction<Float> wrapFloat;
                FloatList blankList = new FloatList();
                for (String txt : blankTxts) {
                    try {
                        blankList.add(Float.parseFloat(txt));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                float[] fArray = blankList.toFloatArray();
                int nblank = fArray.length;
                if (nblank == 0) {
                    wrapFloat = Float::valueOf;
                    maskFloat = f -> f;
                } else if (nblank == 1) {
                    float blank = fArray[0];
                    wrapFloat = f -> f == blank ? null : Float.valueOf(f);
                    maskFloat = f -> f == blank ? Float.NaN : f;
                } else {
                    wrapFloat = f -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (f != fArray[i]) continue;
                            return null;
                        }
                        return Float.valueOf(f);
                    };
                    maskFloat = f -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (f != fArray[i]) continue;
                            return Float.NaN;
                        }
                        return f;
                    };
                }
                return new FieldReader<Float, float[]>(ftype, Float.class, float[].class){

                    @Override
                    public Float readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        return (Float)wrapFloat.apply(adapter.getFloat(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, float[] array, int iel) {
                        array[iel] = maskFloat.applyAsFloat(adapter.getFloat(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public float[] createArray(int n) {
                        return new float[n];
                    }
                };
            }
            case ASCII_REAL: 
            case IEEE754LSBDOUBLE: 
            case IEEE754MSBDOUBLE: {
                DoubleUnaryOperator maskDouble;
                DoubleFunction<Double> wrapDouble;
                DoubleList blankList = new DoubleList();
                for (String txt : blankTxts) {
                    try {
                        blankList.add(Double.parseDouble(txt));
                    }
                    catch (NumberFormatException blank) {
                        // empty catch block
                    }
                }
                double[] dArray = blankList.toDoubleArray();
                int nblank = dArray.length;
                if (nblank == 0) {
                    wrapDouble = Double::valueOf;
                    maskDouble = d -> d;
                } else if (nblank == 1) {
                    double blank = dArray[0];
                    wrapDouble = d -> d == blank ? null : Double.valueOf(d);
                    maskDouble = d -> d == blank ? Double.NaN : d;
                } else {
                    wrapDouble = d -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (d != dArray[i]) continue;
                            return null;
                        }
                        return d;
                    };
                    maskDouble = d -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (d != dArray[i]) continue;
                            return Double.NaN;
                        }
                        return d;
                    };
                }
                return new FieldReader<Double, double[]>(ftype, Double.class, double[].class){

                    @Override
                    public Double readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        return (Double)wrapDouble.apply(adapter.getDouble(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, double[] array, int iel) {
                        array[iel] = maskDouble.applyAsDouble(adapter.getDouble(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public double[] createArray(int n) {
                        return new double[n];
                    }
                };
            }
            case UNSIGNEDLSB8: 
            case UNSIGNEDMSB8: {
                Function<BigInteger, Long> wrapBigint;
                ArrayList<BigInteger> blankList = new ArrayList<BigInteger>();
                for (String txt : blankTxts) {
                    try {
                        blankList.add(new BigInteger(txt));
                    }
                    catch (NumberFormatException blank) {
                        // empty catch block
                    }
                }
                BigInteger[] bigIntegerArray = blankList.toArray(new BigInteger[0]);
                int nblank = bigIntegerArray.length;
                BigInteger max = BigInteger.valueOf(Long.MAX_VALUE);
                BigInteger min = BigInteger.valueOf(Long.MIN_VALUE);
                Function<BigInteger, Long> wrapBigint0 = b -> b.compareTo(min) >= 1 && b.compareTo(max) <= 1 ? Long.valueOf(b.longValue()) : null;
                if (nblank == 0) {
                    wrapBigint = wrapBigint0;
                } else if (nblank == 1) {
                    BigInteger blank = bigIntegerArray[0];
                    wrapBigint = b -> blank.equals(b) ? null : (Long)wrapBigint0.apply((BigInteger)b);
                } else {
                    wrapBigint = b -> {
                        for (int i = 0; i < nblank; ++i) {
                            if (!bigIntegerArray[i].equals(b)) continue;
                            return null;
                        }
                        return (Long)wrapBigint0.apply((BigInteger)b);
                    };
                }
                return new FieldReader<Long, long[]>(ftype, Long.class, long[].class){

                    @Override
                    public Long readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                        return (Long)wrapBigint.apply(adapter.getBigInteger(buf, off, leng, startBit, endBit));
                    }

                    @Override
                    public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, long[] array, int iel) {
                        array[iel] = adapter.getLong(buf, off, leng, startBit, endBit);
                    }

                    @Override
                    public long[] createArray(int n) {
                        return new long[n];
                    }
                };
            }
        }
        logger_.warning("Unknown PDS4 FieldType " + (Object)((Object)ftype) + ", treat as String");
        assert (false);
        return new FieldReader<String, String[]>(ftype, String.class, String[].class){

            @Override
            public String readScalar(byte[] buf, int off, int leng, int startBit, int endBit) {
                String txt = adapter.getString(buf, off, leng, startBit, endBit);
                return txt == null ? null : txt.trim();
            }

            @Override
            public void readElement(byte[] buf, int off, int leng, int startBit, int endBit, String[] array, int iel) {
                String txt = adapter.getString(buf, off, leng, startBit, endBit);
                array[iel] = txt == null ? null : txt.trim();
            }

            @Override
            public String[] createArray(int n) {
                return new String[n];
            }
        };
    }

    @FunctionalInterface
    private static interface FloatUnaryOperator {
        public float applyAsFloat(float var1);
    }

    @FunctionalInterface
    private static interface FloatFunction<R> {
        public R apply(float var1);
    }

    @FunctionalInterface
    private static interface ShortFunction<R> {
        public R apply(short var1);
    }
}

