/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.connect;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileSystemView;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.FileNode;
import uk.ac.starlink.connect.Node;

public class FileBranch
extends FileNode
implements Branch {
    private boolean hidingEnabled_ = true;
    private static final FileSystemView fsv_ = FileSystemView.getFileSystemView();

    public FileBranch(File dir) {
        super(dir);
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not directory");
        }
    }

    @Override
    public Node[] getChildren() {
        File[] files = this.file_.listFiles();
        if (files == null) {
            return new Node[0];
        }
        ArrayList<FileNode> nodeList = new ArrayList<FileNode>(files.length);
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (this.hidingEnabled_ && fsv_.isHiddenFile(file)) continue;
            nodeList.add(FileBranch.createNode(file));
        }
        return nodeList.toArray(new Node[0]);
    }

    @Override
    public Node createNode(String location) {
        FileNode node;
        File file = new File(location);
        if (!file.isAbsolute()) {
            file = new File(this.file_, location);
        }
        if ((node = FileBranch.createNode(file)) instanceof FileBranch) {
            ((FileBranch)node).setHidingEnabled(this.hidingEnabled_);
        }
        return node;
    }

    public boolean isHidingEnabled() {
        return this.hidingEnabled_;
    }

    public void setHidingEnabled(boolean hiding) {
        this.hidingEnabled_ = hiding;
    }
}

