/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Logger;
import uk.ac.bristol.star.feather.AbstractColumnWriter;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.FeatherColumnWriter;
import uk.ac.bristol.star.feather.FeatherType;

public abstract class VariableLengthRandomWriter
extends AbstractColumnWriter {
    private final long nrow_;
    private static final Logger logger_ = Logger.getLogger(VariableLengthRandomWriter.class.getName());

    protected VariableLengthRandomWriter(String string, FeatherType featherType, long l, boolean bl, String string2) {
        super(string, featherType, l, bl, string2);
        this.nrow_ = l;
    }

    protected abstract int getByteSize(long var1);

    protected abstract void writeItem(long var1, OutputStream var3) throws IOException;

    @Override
    public long writeDataBytes(OutputStream outputStream) throws IOException {
        IndexStatus indexStatus = this.writeOffsets(outputStream);
        long l = indexStatus.byteCount_;
        long l2 = 4L * (this.nrow_ + 1L);
        l2 += (long)BufUtils.align8(outputStream, l2);
        long l3 = indexStatus.entryCount_;
        for (long i = 0L; i < l3; ++i) {
            this.writeItem(i, outputStream);
        }
        l += (long)BufUtils.align8(outputStream, l);
        return l2 + l;
    }

    private IndexStatus writeOffsets(OutputStream outputStream) throws IOException {
        long l = 0L;
        for (long i = 0L; i < this.nrow_; ++i) {
            BufUtils.writeLittleEndianInt(outputStream, (int)l);
            long l2 = l + (long)this.getByteSize(i);
            if (l2 >= Integer.MAX_VALUE) {
                logger_.warning("Pointer overflow - empty values in column " + this.getName() + " past row " + i);
                IndexStatus indexStatus = new IndexStatus(i, l);
                while (i < this.nrow_) {
                    BufUtils.writeLittleEndianInt(outputStream, (int)l);
                    ++i;
                }
                return indexStatus;
            }
            l = l2;
        }
        BufUtils.writeLittleEndianInt(outputStream, (int)l);
        return new IndexStatus(this.nrow_, l);
    }

    public static FeatherColumnWriter createStringWriter(String string, final String[] stringArray, String string2, boolean bl) {
        return new VariableLengthRandomWriter(string, FeatherType.UTF8, stringArray.length, bl, string2){

            @Override
            public boolean isNull(long l) {
                return stringArray[this.longToInt(l)] == null;
            }

            @Override
            public int getByteSize(long l) {
                String string = stringArray[this.longToInt(l)];
                return string == null ? 0 : BufUtils.utf8Length(string);
            }

            @Override
            public void writeItem(long l, OutputStream outputStream) throws IOException {
                String string = stringArray[this.longToInt(l)];
                if (string != null) {
                    outputStream.write(string.getBytes(BufUtils.UTF8));
                }
            }

            private int longToInt(long l) {
                int n = (int)l;
                if ((long)n == l) {
                    return n;
                }
                throw new IllegalArgumentException("integer overflow");
            }
        };
    }

    private static class IndexStatus {
        final long entryCount_;
        final long byteCount_;

        IndexStatus(long l, long l2) {
            this.entryCount_ = l;
            this.byteCount_ = l2;
        }
    }
}

